/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.replication.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.message.AbandonListener;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.future.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplSearchListener.class);
    private LdapSession session;
    private SearchRequest req;
    private volatile boolean pushInRealTime;
    private final ReplicaEventLog clientMsgLog;

    SyncReplSearchListener(LdapSession session, SearchRequest req, ReplicaEventLog clientMsgLog, boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
        this.setSession(session);
        this.setReq(req);
        this.clientMsgLog = clientMsgLog;
    }

    public void setSession(LdapSession session) {
        this.session = session;
    }

    public void setReq(SearchRequest req) {
        this.req = req;
        if (req != null) {
            req.addAbandonListener(this);
        }
    }

    public void abandon() throws Exception {
        if (this.session != null) {
            this.session.getCoreSession().getDirectoryService().getEventService().removeListener(this);
        }
    }

    public void requestAbandoned(AbandonableRequest req) {
        try {
            this.abandon();
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_164, new Object[0]), e);
        }
    }

    public void entryAdded(AddOperationContext addContext) {
        Entry entry = addContext.getEntry();
        LOG.debug("sending added entry {}", entry.getDn());
        try {
            if (this.pushInRealTime) {
                SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
                respEntry.setObjectName(entry.getDn());
                respEntry.setEntry(entry);
                SyncStateValueDecorator syncAdd = new SyncStateValueDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
                syncAdd.setSyncStateType(SyncStateTypeEnum.ADD);
                syncAdd.setEntryUUID(Strings.uuidToBytes(entry.get("entryUUID").getString()));
                syncAdd.setCookie(this.getCookie(entry));
                respEntry.addControl(syncAdd);
                WriteFuture future = this.session.getIoSession().write(respEntry);
                this.handleWriteFuture(future, entry, EventType.ADD, null);
            } else {
                this.clientMsgLog.log(EventType.ADD, addContext.getEntry());
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void entryDeleted(DeleteOperationContext deleteContext) {
        this.sendDeletedEntry(deleteContext.getEntry());
    }

    private void sendDeletedEntry(Entry entry) {
        LOG.debug("sending deleted entry {}", entry.getDn());
        try {
            if (this.pushInRealTime) {
                SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
                respEntry.setObjectName(entry.getDn());
                respEntry.setEntry(entry);
                SyncStateValueDecorator syncDelete = new SyncStateValueDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
                syncDelete.setSyncStateType(SyncStateTypeEnum.DELETE);
                syncDelete.setEntryUUID(Strings.uuidToBytes(entry.get("entryUUID").getString()));
                syncDelete.setCookie(this.getCookie(entry));
                respEntry.addControl(syncDelete);
                WriteFuture future = this.session.getIoSession().write(respEntry);
                this.handleWriteFuture(future, entry, EventType.DELETE, null);
            } else {
                this.clientMsgLog.log(EventType.DELETE, entry);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void entryModified(ModifyOperationContext modifyContext) {
        Entry alteredEntry = modifyContext.getAlteredEntry();
        LOG.debug("sending modified entry {}", alteredEntry.getDn());
        try {
            if (this.pushInRealTime) {
                SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
                respEntry.setObjectName(modifyContext.getDn());
                respEntry.setEntry(alteredEntry);
                SyncStateValueDecorator syncModify = new SyncStateValueDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
                syncModify.setSyncStateType(SyncStateTypeEnum.MODIFY);
                syncModify.setEntryUUID(Strings.uuidToBytes(alteredEntry.get("entryUUID").getString()));
                syncModify.setCookie(this.getCookie(alteredEntry));
                respEntry.addControl(syncModify);
                WriteFuture future = this.session.getIoSession().write(respEntry);
                this.handleWriteFuture(future, alteredEntry, EventType.MODIFY, null);
            } else {
                this.clientMsgLog.log(EventType.MODIFY, modifyContext.getAlteredEntry());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void entryMoved(MoveOperationContext moveContext) {
        Entry entry = moveContext.getOriginalEntry();
        LOG.debug("sending moved entry {}", entry.getDn());
        try {
            if (!moveContext.getNewSuperior().isDescendantOf(this.clientMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(entry);
                return;
            }
            SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService(), SyncModifyDnType.MOVE);
            modDnControl.setEntryDn(moveContext.getDn().getNormName());
            modDnControl.setNewSuperiorDn(moveContext.getNewSuperior().getNormName());
            if (this.pushInRealTime) {
                SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
                respEntry.setObjectName(moveContext.getDn());
                respEntry.setEntry(entry);
                SyncStateValueDecorator syncModify = new SyncStateValueDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
                syncModify.setSyncStateType(SyncStateTypeEnum.MODDN);
                syncModify.setEntryUUID(Strings.uuidToBytes(entry.get("entryUUID").getString()));
                syncModify.setCookie(this.getCookie(entry));
                respEntry.addControl(syncModify);
                respEntry.addControl(modDnControl);
                WriteFuture future = this.session.getIoSession().write(respEntry);
                this.handleWriteFuture(future, entry, null, modDnControl);
            } else {
                this.clientMsgLog.log(new ReplicaEventMessage(modDnControl, entry));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        LOG.debug("sending moveAndRenamed entry {}", moveAndRenameContext.getDn());
        try {
            if (!moveAndRenameContext.getNewSuperiorDn().isDescendantOf(this.clientMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(moveAndRenameContext.getEntry());
                return;
            }
            SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService(), SyncModifyDnType.MOVEANDRENAME);
            modDnControl.setEntryDn(moveAndRenameContext.getDn().getNormName());
            modDnControl.setNewSuperiorDn(moveAndRenameContext.getNewSuperiorDn().getNormName());
            modDnControl.setNewRdn(moveAndRenameContext.getNewRdn().getNormName());
            modDnControl.setDeleteOldRdn(moveAndRenameContext.getDeleteOldRdn());
            if (this.pushInRealTime) {
                Entry alteredEntry = moveAndRenameContext.getModifiedEntry();
                SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
                respEntry.setObjectName(moveAndRenameContext.getModifiedEntry().getDn());
                respEntry.setEntry(alteredEntry);
                SyncStateValueDecorator syncModify = new SyncStateValueDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
                syncModify.setSyncStateType(SyncStateTypeEnum.MODDN);
                syncModify.setEntryUUID(Strings.uuidToBytes(alteredEntry.get("entryUUID").getString()));
                syncModify.setCookie(this.getCookie(alteredEntry));
                respEntry.addControl(syncModify);
                respEntry.addControl(modDnControl);
                WriteFuture future = this.session.getIoSession().write(respEntry);
                this.handleWriteFuture(future, alteredEntry, null, modDnControl);
            } else {
                this.clientMsgLog.log(new ReplicaEventMessage(modDnControl, moveAndRenameContext.getEntry()));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void entryRenamed(RenameOperationContext renameContext) {
        Entry entry = renameContext.getEntry();
        LOG.debug("sending renamed entry {}", entry.getDn());
        try {
            SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
            modDnControl.setModDnType(SyncModifyDnType.RENAME);
            modDnControl.setEntryDn(renameContext.getDn().getName());
            modDnControl.setNewRdn(renameContext.getNewRdn().getName());
            modDnControl.setDeleteOldRdn(renameContext.getDeleteOldRdn());
            if (this.pushInRealTime) {
                SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
                respEntry.setObjectName(entry.getDn());
                respEntry.setEntry(entry);
                SyncStateValueDecorator syncModify = new SyncStateValueDecorator(this.session.getLdapServer().getDirectoryService().getLdapCodecService());
                syncModify.setSyncStateType(SyncStateTypeEnum.MODDN);
                syncModify.setEntryUUID(Strings.uuidToBytes(entry.get("entryUUID").getString()));
                syncModify.setCookie(this.getCookie(renameContext.getModifiedEntry()));
                respEntry.addControl(syncModify);
                respEntry.addControl(modDnControl);
                WriteFuture future = this.session.getIoSession().write(respEntry);
                this.handleWriteFuture(future, renameContext.getModifiedEntry(), null, modDnControl);
            } else {
                this.clientMsgLog.log(new ReplicaEventMessage(modDnControl, renameContext.getEntry()));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public boolean isPushInRealTime() {
        return this.pushInRealTime;
    }

    public void setPushInRealTime(boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
    }

    private byte[] getCookie(Entry entry) throws LdapInvalidAttributeValueException {
        String csn = entry.get("entryCSN").getString();
        return Strings.getBytesUtf8(this.clientMsgLog.getId() + ";" + csn);
    }

    private void handleWriteFuture(WriteFuture future, Entry entry, EventType event, SyncModifyDnDecorator modDnControl) {
        future.awaitUninterruptibly();
        if (!future.isWritten()) {
            LOG.error("Failed to write to the consumer {}", this.clientMsgLog.getId());
            LOG.error("", future.getException());
            this.pushInRealTime = false;
            if (modDnControl != null) {
                this.clientMsgLog.log(new ReplicaEventMessage(modDnControl, entry));
            } else {
                this.clientMsgLog.log(event, entry);
            }
        }
    }
}

