/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.ldap.replication.ReplicaEventLogCursor;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.SyncReplSearchListener;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaEventLog {
    private String hostName;
    private String searchFilter;
    private String lastSentCsn;
    private SyncReplSearchListener persistentListener;
    private NotificationCriteria searchCriteria;
    private int replicaId;
    private boolean refreshNPersist;
    private ActiveMQSession amqSession;
    private ActiveMQQueue queue;
    private ActiveMQMessageProducer producer;
    private ActiveMQConnection amqConnection;
    private BrokerService brokerService;
    private volatile boolean dirty;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventLog.class);

    public ReplicaEventLog() {
    }

    public ReplicaEventLog(int replicaId) {
        this.replicaId = replicaId;
        this.searchCriteria = new NotificationCriteria();
        this.searchCriteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
    }

    public void configure(ActiveMQConnection amqConnection, BrokerService brokerService) throws Exception {
        if (this.amqSession == null || !this.amqSession.isRunning()) {
            this.amqConnection = amqConnection;
            this.amqSession = (ActiveMQSession)amqConnection.createSession(false, 1);
            this.queue = (ActiveMQQueue)this.amqSession.createQueue(this.getQueueName());
            this.producer = (ActiveMQMessageProducer)this.amqSession.createProducer(this.queue);
            this.brokerService = brokerService;
        }
    }

    public void log(EventType event, Entry entry) {
        LOG.debug("logging entry with Dn {} with the event {}", entry.getDn(), (Object)event);
        this.log(new ReplicaEventMessage(event, entry));
    }

    public void log(ReplicaEventMessage message) {
        try {
            ActiveMQObjectMessage ObjectMessage2 = (ActiveMQObjectMessage)this.amqSession.createObjectMessage();
            ObjectMessage2.setObject(message);
            this.producer.send(ObjectMessage2);
        }
        catch (Exception e) {
            LOG.warn("Failed to insert the entry into syncrepl log", e);
        }
    }

    public void truncate() throws Exception {
        this.producer.close();
        String queueName = this.queue.getQueueName();
        LOG.debug("deleting the queue {}", (Object)queueName);
        this.amqConnection.destroyDestination(this.queue);
        this.queue = null;
    }

    public void recreate() throws Exception {
        LOG.debug("recreating the queue for the replica id {}", this.replicaId);
        this.queue = (ActiveMQQueue)this.amqSession.createQueue(this.getQueueName());
        this.producer = (ActiveMQMessageProducer)this.amqSession.createProducer(this.queue);
    }

    public void stop() throws Exception {
        this.producer.close();
        this.amqSession.close();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReplicaEventLog)) {
            return false;
        }
        ReplicaEventLog other = (ReplicaEventLog)obj;
        return this.replicaId == other.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.searchFilter.hashCode();
        result = 31 * result + this.hostName.hashCode();
        return result;
    }

    public int compareTo(ReplicaEventLog o) {
        if (this.equals(o)) {
            return 0;
        }
        return 1;
    }

    public SyncReplSearchListener getPersistentListener() {
        return this.persistentListener;
    }

    public void setPersistentListener(SyncReplSearchListener persistentListener) {
        this.persistentListener = persistentListener;
    }

    public NotificationCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(NotificationCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public boolean isRefreshNPersist() {
        return this.refreshNPersist;
    }

    public void setRefreshNPersist(boolean refreshNPersist) {
        this.refreshNPersist = refreshNPersist;
    }

    public int getId() {
        return this.replicaId;
    }

    public String getLastSentCsn() {
        return this.lastSentCsn;
    }

    public void setLastSentCsn(String lastSentCsn) {
        if (!lastSentCsn.equals(this.lastSentCsn)) {
            this.lastSentCsn = lastSentCsn;
            this.dirty = true;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getQueueName() {
        return "replicaId=" + this.replicaId;
    }

    public ReplicaEventLogCursor getCursor() throws Exception {
        Queue regionQueue = (Queue)this.brokerService.getRegionBroker().getDestinationMap().get(this.queue);
        return new ReplicaEventLogCursor(this.amqSession, this.queue, regionQueue);
    }

    public String toString() {
        return "ClientMessageQueueLog [ipAddress=" + this.hostName + ", filter=" + this.searchFilter + ", replicaId=" + this.replicaId + ", lastSentCookie=" + this.lastSentCsn + "]";
    }
}

