/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosKeyFactory {
    private static final Map<EncryptionType, String> DEFAULT_CIPHERS;

    public static Map<EncryptionType, EncryptionKey> getKerberosKeys(String principalName, String passPhrase) {
        return KerberosKeyFactory.getKerberosKeys(principalName, passPhrase, DEFAULT_CIPHERS.keySet());
    }

    public static Map<EncryptionType, EncryptionKey> getKerberosKeys(String principalName, String passPhrase, Set<EncryptionType> ciphers) {
        KerberosPrincipal principal = new KerberosPrincipal(principalName);
        HashMap<EncryptionType, EncryptionKey> kerberosKeys = new HashMap<EncryptionType, EncryptionKey>();
        for (EncryptionType encryptionType : ciphers) {
            String algorithm = DEFAULT_CIPHERS.get((Object)encryptionType);
            try {
                KerberosKey kerberosKey = new KerberosKey(principal, passPhrase.toCharArray(), algorithm);
                EncryptionKey encryptionKey = new EncryptionKey(encryptionType, kerberosKey.getEncoded(), kerberosKey.getVersionNumber());
                kerberosKeys.put(encryptionType, encryptionKey);
            }
            catch (IllegalArgumentException iae) {}
        }
        return kerberosKeys;
    }

    static {
        HashMap<EncryptionType, String> map = new HashMap<EncryptionType, String>();
        map.put(EncryptionType.DES_CBC_MD5, "DES");
        map.put(EncryptionType.DES3_CBC_SHA1_KD, "DESede");
        map.put(EncryptionType.RC4_HMAC, "ArcFourHmac");
        map.put(EncryptionType.AES128_CTS_HMAC_SHA1_96, "AES128");
        map.put(EncryptionType.AES256_CTS_HMAC_SHA1_96, "AES256");
        DEFAULT_CIPHERS = Collections.unmodifiableMap(map);
    }
}

