/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.Set;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.shared.ldap.model.name.Dn;

public class LdifPartitionFactory
implements PartitionFactory {
    public LdifPartition createPartition(String id, String suffix, int cacheSize, File workingDirectory) throws Exception {
        LdifPartition partition = new LdifPartition();
        partition.setId(id);
        partition.setSuffix(new Dn(suffix));
        partition.setCacheSize(500);
        partition.setPartitionPath(workingDirectory.toURI());
        return partition;
    }

    public void addIndex(Partition partition, String attributeId, int cacheSize) throws Exception {
        if (!(partition instanceof LdifPartition)) {
            throw new IllegalArgumentException("Partition must be a LdifPartition");
        }
        LdifPartition ldifPartition = (LdifPartition)partition;
        Set indexedAttributes = ldifPartition.getIndexedAttributes();
        AvlIndex index = new AvlIndex(attributeId);
        indexedAttributes.add(index);
        ldifPartition.setIndexedAttributes(indexedAttributes);
    }
}

