/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapAliasException;
import org.apache.directory.shared.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;

public class ExceptionInterceptor
extends BaseInterceptor {
    private PartitionNexus nexus;
    private Dn subschemSubentryDn;
    private final LRUMap notAliasCache = new LRUMap(100);
    private static final int DEFAULT_CACHE_SIZE = 100;

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        Value<?> attr = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemSubentryDn = directoryService.getDnFactory().create(attr.getString());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NextInterceptor nextInterceptor, AddOperationContext addContext) throws LdapException {
        boolean notAnAlias;
        Dn name = addContext.getDn();
        if (this.subschemSubentryDn.getNormName().equals(name.getNormName())) {
            throw new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_249, new Object[0]));
        }
        if (nextInterceptor.hasEntry(new EntryOperationContext(addContext.getSession(), name))) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_250_ENTRY_ALREADY_EXISTS, name.getName()));
            throw ne;
        }
        Dn suffix = this.nexus.findSuffix(name);
        if (suffix.equals(name)) {
            nextInterceptor.add(addContext);
            return;
        }
        Dn parentDn = name.getParent();
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            notAnAlias = this.notAliasCache.containsKey(parentDn.getNormName());
        }
        if (!notAnAlias) {
            Entry attrs;
            try {
                attrs = addContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            }
            catch (Exception e) {
                LdapNoSuchObjectException e2 = new LdapNoSuchObjectException(I18n.err(I18n.ERR_251_PARENT_NOT_FOUND, parentDn.getName()));
                throw e2;
            }
            Attribute objectClass = ((ClonedServerEntry)attrs).getOriginalEntry().get(OBJECT_CLASS_AT);
            if (objectClass.contains("alias")) {
                String msg = I18n.err(I18n.ERR_252_ALIAS_WITH_CHILD_NOT_ALLOWED, name.getName(), parentDn.getName());
                LdapAliasException e = new LdapAliasException(msg);
                throw e;
            }
            LRUMap lRUMap2 = this.notAliasCache;
            synchronized (lRUMap2) {
                this.notAliasCache.put(parentDn.getNormName(), parentDn);
            }
        }
        nextInterceptor.add(addContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_253, this.subschemSubentryDn));
        }
        nextInterceptor.delete(deleteContext);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(dn.getNormName())) {
                this.notAliasCache.remove(dn.getNormName());
            }
        }
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext listContext) throws LdapException {
        if (listContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), listContext);
        }
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(listContext, msg, listContext.getDn());
        return nextInterceptor.list(listContext);
    }

    public Entry lookup(NextInterceptor nextInterceptor, LookupOperationContext lookupContext) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            Entry serverEntry = this.directoryService.getSchemaService().getSubschemaEntry(lookupContext.getAttrsIdArray());
            serverEntry.setDn(dn);
            return serverEntry;
        }
        Entry result = nextInterceptor.lookup(lookupContext);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext modifyContext) throws LdapException {
        String msg = "Attempt to modify non-existant entry: ";
        if (modifyContext.getDn().equals(this.subschemSubentryDn)) {
            nextInterceptor.modify(modifyContext);
            return;
        }
        this.assertHasEntry(modifyContext, msg);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(modifyContext.getDn().getNormName())) {
                this.notAliasCache.remove(modifyContext.getDn().getNormName());
            }
        }
        nextInterceptor.modify(modifyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext renameContext) throws LdapException {
        Dn dn = renameContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_255, this.subschemSubentryDn, this.subschemSubentryDn));
        }
        Dn newDn = renameContext.getNewDn();
        if (nextInterceptor.hasEntry(new EntryOperationContext(renameContext.getSession(), newDn))) {
            LdapEntryAlreadyExistsException e = new LdapEntryAlreadyExistsException(I18n.err(I18n.ERR_250_ENTRY_ALREADY_EXISTS, newDn.getName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(dn.getNormName())) {
                this.notAliasCache.remove(dn.getNormName());
            }
        }
        nextInterceptor.rename(renameContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(NextInterceptor nextInterceptor, MoveOperationContext moveContext) throws LdapException {
        Dn oriChildName = moveContext.getDn();
        if (oriChildName.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_258, this.subschemSubentryDn, this.subschemSubentryDn));
        }
        nextInterceptor.move(moveContext);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(oriChildName.getNormName())) {
                this.notAliasCache.remove(oriChildName.getNormName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        if (oldDn.equals(this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_258, this.subschemSubentryDn, this.subschemSubentryDn));
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(oldDn.getNormName())) {
                this.notAliasCache.remove(oldDn.getNormName());
            }
        }
        nextInterceptor.moveAndRename(moveAndRenameContext);
    }

    private void assertHasEntry(OperationContext opContext, String msg) throws LdapException {
        Dn dn = opContext.getDn();
        if (this.subschemSubentryDn.equals(dn)) {
            return;
        }
        if (opContext.getEntry() == null) {
            LdapNoSuchObjectException e = msg != null ? new LdapNoSuchObjectException(msg + dn.getName()) : new LdapNoSuchObjectException(dn.getName());
            throw e;
        }
    }

    private void assertHasEntry(OperationContext opContext, String msg, Dn dn) throws LdapException {
        if (this.subschemSubentryDn.equals(dn)) {
            return;
        }
        if (!opContext.hasEntry(dn, ByPassConstants.HAS_ENTRY_BYPASS)) {
            LdapNoSuchObjectException e = msg != null ? new LdapNoSuchObjectException(msg + dn.getName()) : new LdapNoSuchObjectException(dn.getName());
            throw e;
        }
    }
}

