/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.event.RegistrationEntry;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EventInterceptor.class);
    private List<RegistrationEntry> registrations = new CopyOnWriteArrayList<RegistrationEntry>();
    private FilterNormalizingVisitor filterNormalizer;
    private Evaluator evaluator;
    private ExecutorService executor;

    @Override
    public void init(DirectoryService directpryService) throws LdapException {
        LOG.info("Initializing ...");
        super.init(directpryService);
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.filterNormalizer = new FilterNormalizingVisitor(ncn, this.schemaManager);
        this.evaluator = new ExpressionEvaluator(this.schemaManager);
        this.executor = new ThreadPoolExecutor(1, 10, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100));
        this.directoryService.setEventService(new DefaultEventService());
        LOG.info("Initialization complete.");
    }

    private void fire(final OperationContext opContext, EventType type, final DirectoryListener listener) {
        switch (type) {
            case ADD: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryAdded((AddOperationContext)opContext);
                    }
                });
                break;
            }
            case DELETE: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryDeleted((DeleteOperationContext)opContext);
                    }
                });
                break;
            }
            case MODIFY: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryModified((ModifyOperationContext)opContext);
                    }
                });
                break;
            }
            case MOVE: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryMoved((MoveOperationContext)opContext);
                    }
                });
                break;
            }
            case RENAME: {
                this.executor.execute(new Runnable(){

                    public void run() {
                        listener.entryRenamed((RenameOperationContext)opContext);
                    }
                });
            }
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        next.add(addContext);
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(addContext.getDn(), addContext.getEntry());
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isAdd(registration.getCriteria().getEventMask())) continue;
            this.fire(addContext, EventType.ADD, registration.getListener());
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(deleteContext.getDn(), deleteContext.getEntry());
        next.delete(deleteContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isDelete(registration.getCriteria().getEventMask())) continue;
            this.fire(deleteContext, EventType.DELETE, registration.getListener());
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        Entry oriEntry = modifyContext.getEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(modifyContext.getDn(), oriEntry);
        next.modify(modifyContext);
        if (selecting.isEmpty()) {
            return;
        }
        Entry alteredEntry = modifyContext.lookup(modifyContext.getDn(), ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        modifyContext.setAlteredEntry(alteredEntry);
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isModify(registration.getCriteria().getEventMask())) continue;
            this.fire(modifyContext, EventType.MODIFY, registration.getListener());
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        Entry oriEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(renameContext.getDn(), oriEntry);
        next.rename(renameContext);
        if (selecting.isEmpty()) {
            return;
        }
        Entry alteredEntry = renameContext.lookup(renameContext.getNewDn(), ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        renameContext.setModifiedEntry(alteredEntry);
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isRename(registration.getCriteria().getEventMask())) continue;
            this.fire(renameContext, EventType.RENAME, registration.getListener());
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, final MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry oriEntry = moveAndRenameContext.getOriginalEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(moveAndRenameContext.getDn(), oriEntry);
        next.moveAndRename(moveAndRenameContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (final RegistrationEntry registration : selecting) {
            if (!EventType.isMoveAndRename(registration.getCriteria().getEventMask())) continue;
            this.executor.execute(new Runnable(){

                public void run() {
                    registration.getListener().entryMovedAndRenamed(moveAndRenameContext);
                }
            });
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        Entry oriEntry = moveContext.getOriginalEntry();
        List<RegistrationEntry> selecting = this.getSelectingRegistrations(moveContext.getDn(), oriEntry);
        next.move(moveContext);
        if (selecting.isEmpty()) {
            return;
        }
        for (RegistrationEntry registration : selecting) {
            if (!EventType.isMove(registration.getCriteria().getEventMask())) continue;
            this.fire(moveContext, EventType.MOVE, registration.getListener());
        }
    }

    List<RegistrationEntry> getSelectingRegistrations(Dn name, Entry entry) throws LdapException {
        if (this.registrations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegistrationEntry> selecting = new ArrayList<RegistrationEntry>();
        for (RegistrationEntry registration : this.registrations) {
            NotificationCriteria criteria = registration.getCriteria();
            Dn base = criteria.getBase();
            if (!criteria.getFilter().isSchemaAware()) {
                criteria.getFilter().accept(this.filterNormalizer);
            }
            if (!name.equals(base) && !name.isDescendantOf(base) || !this.evaluator.evaluate(criteria.getFilter(), base, entry)) continue;
            selecting.add(registration);
        }
        return selecting;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultEventService
    implements EventService {
        DefaultEventService() {
        }

        @Override
        public void addListener(DirectoryListener listener) {
            EventInterceptor.this.registrations.add(new RegistrationEntry(listener));
        }

        @Override
        public void addListener(DirectoryListener listener, NotificationCriteria criteria) throws Exception {
            criteria.getBase().apply(EventInterceptor.this.directoryService.getSchemaManager());
            ExprNode result = (ExprNode)criteria.getFilter().accept(EventInterceptor.this.filterNormalizer);
            criteria.setFilter(result);
            EventInterceptor.this.registrations.add(new RegistrationEntry(listener, criteria));
        }

        @Override
        public void removeListener(DirectoryListener listener) {
            for (RegistrationEntry entry : EventInterceptor.this.registrations) {
                if (entry.getListener() != listener) continue;
                EventInterceptor.this.registrations.remove(entry);
            }
        }

        @Override
        public List<RegistrationEntry> getRegistrationEntries() {
            return Collections.unmodifiableList(EventInterceptor.this.registrations);
        }
    }
}

