/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogEvent {
    private String zuluTime;
    private LdapPrincipal committer;
    private long revision;
    private LdifEntry forwardLdif;
    private List<LdifEntry> reverseLdifs;

    public ChangeLogEvent(long revision, String zuluTime, LdapPrincipal committer, LdifEntry forwardLdif, LdifEntry reverseLdif) {
        this.zuluTime = zuluTime;
        this.revision = revision;
        this.forwardLdif = forwardLdif;
        this.reverseLdifs = new ArrayList<LdifEntry>(1);
        this.reverseLdifs.add(reverseLdif);
        this.committer = committer;
    }

    public ChangeLogEvent(long revision, String zuluTime, LdapPrincipal committer, LdifEntry forwardLdif, List<LdifEntry> reverseLdifs) {
        this.zuluTime = zuluTime;
        this.revision = revision;
        this.forwardLdif = forwardLdif;
        this.reverseLdifs = reverseLdifs;
        this.committer = committer;
    }

    public LdifEntry getForwardLdif() {
        return this.forwardLdif;
    }

    public List<LdifEntry> getReverseLdifs() {
        return this.reverseLdifs;
    }

    public LdapPrincipal getCommitterPrincipal() {
        return this.committer;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getZuluTime() {
        return this.zuluTime;
    }

    public Attribute get(String attributeName) {
        return this.forwardLdif.get(attributeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeLogEvent { ");
        sb.append("principal=").append(this.getCommitterPrincipal()).append(", ");
        sb.append("zuluTime=").append(this.getZuluTime()).append(", ");
        sb.append("revision=").append(this.getRevision()).append(", ");
        sb.append("\nforwardLdif=").append(this.getForwardLdif()).append(", ");
        if (this.reverseLdifs != null) {
            sb.append("\nreverseLdif number=").append(this.reverseLdifs.size());
            int i = 0;
            for (LdifEntry reverseLdif : this.reverseLdifs) {
                sb.append("\nReverse[").append(i++).append("] :\n");
                sb.append(reverseLdif);
            }
        }
        sb.append(" }");
        return sb.toString();
    }
}

