/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.subtree.RefinementEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.protectedItem.AllAttributeValuesItem;
import org.apache.directory.shared.ldap.aci.protectedItem.AttributeTypeItem;
import org.apache.directory.shared.ldap.aci.protectedItem.AttributeValueItem;
import org.apache.directory.shared.ldap.aci.protectedItem.ClassesItem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxImmSubItem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxValueCountElem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxValueCountItem;
import org.apache.directory.shared.ldap.aci.protectedItem.RangeOfValuesItem;
import org.apache.directory.shared.ldap.aci.protectedItem.RestrictedByElem;
import org.apache.directory.shared.ldap.aci.protectedItem.RestrictedByItem;
import org.apache.directory.shared.ldap.aci.protectedItem.SelfValueItem;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedProtectedItemFilter
implements ACITupleFilter {
    private final RefinementEvaluator refinementEvaluator;
    private final Evaluator entryEvaluator;
    private final SchemaManager schemaManager;

    public RelatedProtectedItemFilter(RefinementEvaluator refinementEvaluator, Evaluator entryEvaluator, SchemaManager schemaManager) {
        this.refinementEvaluator = refinementEvaluator;
        this.entryEvaluator = entryEvaluator;
        this.schemaManager = schemaManager;
    }

    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (aciContext.getAciTuples().size() == 0) {
            return aciContext.getAciTuples();
        }
        Iterator<ACITuple> i = aciContext.getAciTuples().iterator();
        while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (this.isRelated(tuple, scope, aciContext.getUserDn(), aciContext.getEntryDn(), aciContext.getAttributeType(), aciContext.getAttrValue(), aciContext.getEntry())) continue;
            i.remove();
        }
        return aciContext.getAciTuples();
    }

    private boolean isRelated(ACITuple tuple, OperationScope scope, Dn userName, Dn entryName, AttributeType attributeType, Value<?> attrValue, Entry entry) throws LdapException, InternalError {
        String oid = null;
        if (attributeType != null) {
            oid = attributeType.getOid();
        }
        for (ProtectedItem item : tuple.getProtectedItems()) {
            Iterator<Object> j;
            AttributeType attr;
            Iterator<AttributeType> iterator;
            if (item == ProtectedItem.ENTRY) {
                if (scope != OperationScope.ENTRY) continue;
                return true;
            }
            if (item == ProtectedItem.ALL_USER_ATTRIBUTE_TYPES) {
                if (scope != OperationScope.ATTRIBUTE_TYPE && scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                return true;
            }
            if (item == ProtectedItem.ALL_USER_ATTRIBUTE_TYPES_AND_VALUES) {
                if (scope != OperationScope.ATTRIBUTE_TYPE && scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                return true;
            }
            if (item instanceof AllAttributeValuesItem) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                AllAttributeValuesItem aav = (AllAttributeValuesItem)item;
                iterator = aav.iterator();
                while (iterator.hasNext()) {
                    attr = iterator.next();
                    if (!oid.equals(attr.getOid())) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof AttributeTypeItem) {
                if (scope != OperationScope.ATTRIBUTE_TYPE) continue;
                AttributeTypeItem at = (AttributeTypeItem)item;
                iterator = at.iterator();
                while (iterator.hasNext()) {
                    attr = iterator.next();
                    if (!oid.equals(attr.getOid())) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof AttributeValueItem) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                AttributeValueItem av = (AttributeValueItem)item;
                j = av.iterator();
                while (j.hasNext()) {
                    Attribute entryAttribute = j.next();
                    AttributeType attr2 = entryAttribute.getAttributeType();
                    String attrOid = null;
                    if (attr2 != null) {
                        attrOid = entryAttribute.getAttributeType().getOid();
                    } else {
                        attr2 = (AttributeType)this.schemaManager.getAttributeTypeRegistry().lookup(entryAttribute.getId());
                        attrOid = attr2.getOid();
                        entryAttribute.apply(attr2);
                    }
                    if (!oid.equals(attrOid) || !entryAttribute.contains(attrValue)) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof ClassesItem) {
                ClassesItem refinement = (ClassesItem)item;
                if (!this.refinementEvaluator.evaluate(refinement.getClasses(), entry.get("objectClass"))) continue;
                return true;
            }
            if (item instanceof MaxImmSubItem) {
                return true;
            }
            if (item instanceof MaxValueCountItem) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                MaxValueCountItem mvc = (MaxValueCountItem)item;
                j = mvc.iterator();
                while (j.hasNext()) {
                    MaxValueCountElem mvcItem = (MaxValueCountElem)j.next();
                    if (!oid.equals(mvcItem.getAttributeType().getOid())) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof RangeOfValuesItem) {
                RangeOfValuesItem rov = (RangeOfValuesItem)item;
                if (!this.entryEvaluator.evaluate(rov.getRefinement(), entryName, entry)) continue;
                return true;
            }
            if (item instanceof RestrictedByItem) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) continue;
                RestrictedByItem rb = (RestrictedByItem)item;
                j = rb.iterator();
                while (j.hasNext()) {
                    RestrictedByElem rbItem = (RestrictedByElem)j.next();
                    if (!oid.equals(rbItem.getAttributeType().getOid())) continue;
                    return true;
                }
                continue;
            }
            if (item instanceof SelfValueItem) {
                if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE && scope != OperationScope.ATTRIBUTE_TYPE) continue;
                SelfValueItem sv = (SelfValueItem)item;
                iterator = sv.iterator();
                while (iterator.hasNext()) {
                    Attribute entryAttribute;
                    attr = iterator.next();
                    if (!oid.equals(attr.getOid()) || (entryAttribute = entry.get(oid)) == null || !entryAttribute.contains(userName.getNormName()) && !entryAttribute.contains(userName.getName())) continue;
                    return true;
                }
                continue;
            }
            throw new InternalError(I18n.err(I18n.ERR_232, item.getClass().getName()));
        }
        return false;
    }
}

