/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.admin.AdministrativePointInterceptor;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxImmSubItem;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxImmSubFilter
implements ACITupleFilter {
    private final ExprNode childrenFilter;
    private final SearchControls childrenSearchControls;
    public static final Collection<String> SEARCH_BYPASS;

    public MaxImmSubFilter(SchemaManager schemaManager) {
        AttributeType objectClassAt = null;
        try {
            objectClassAt = schemaManager.lookupAttributeTypeRegistry("objectClass");
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        this.childrenFilter = new PresenceNode(objectClassAt);
        this.childrenSearchControls = new SearchControls();
        this.childrenSearchControls.setSearchScope(1);
    }

    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        ACI_LOG.debug("Filtering MaxImmSub...");
        if (aciContext.getEntryDn().isRootDSE()) {
            return aciContext.getAciTuples();
        }
        if (aciContext.getAciTuples().size() == 0) {
            return aciContext.getAciTuples();
        }
        if (scope != OperationScope.ENTRY) {
            return aciContext.getAciTuples();
        }
        int immSubCount = -1;
        Iterator<ACITuple> i = aciContext.getAciTuples().iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                MaxImmSubItem mis;
                if (!(item instanceof MaxImmSubItem)) continue;
                if (immSubCount < 0) {
                    immSubCount = this.getImmSubCount(aciContext.getOperationContext(), aciContext.getEntryDn());
                }
                if (immSubCount < (mis = (MaxImmSubItem)item).getValue()) continue;
                i.remove();
                continue block0;
            }
        }
        return aciContext.getAciTuples();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getImmSubCount(OperationContext opContext, Dn entryName) throws LdapException {
        int cnt = 0;
        Cursor results = null;
        try {
            Dn baseDn = new Dn(opContext.getSession().getDirectoryService().getSchemaManager(), entryName.getRdn(entryName.size() - 1));
            SearchOperationContext searchContext = new SearchOperationContext(opContext.getSession(), baseDn, this.childrenFilter, this.childrenSearchControls);
            searchContext.setByPassed(SEARCH_BYPASS);
            searchContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            results = opContext.getSession().getDirectoryService().getOperationManager().search(searchContext);
            try {
                while (results.next()) {
                    results.get();
                    ++cnt;
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), e);
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception e) {
                    throw new LdapOperationException(e.getMessage(), e);
                }
            }
        }
        return cnt;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(AdministrativePointInterceptor.class.getName());
        c.add(OperationalAttributeInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(SubentryInterceptor.class.getName());
        c.add(EventInterceptor.class.getName());
        SEARCH_BYPASS = Collections.unmodifiableCollection(c);
    }
}

