/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.authz.GroupCache;
import org.apache.directory.server.core.authz.TupleCache;
import org.apache.directory.server.core.authz.support.ACDFEngine;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.constants.Loggers;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AciAuthorizationInterceptor.class);
    private static final Logger ACI_LOG = LoggerFactory.getLogger(Loggers.ACI_LOG.getName());
    private static final Collection<MicroOperation> ADD_PERMS;
    private static final Collection<MicroOperation> READ_PERMS;
    private static final Collection<MicroOperation> COMPARE_PERMS;
    private static final Collection<MicroOperation> SEARCH_ENTRY_PERMS;
    private static final Collection<MicroOperation> SEARCH_ATTRVAL_PERMS;
    private static final Collection<MicroOperation> REMOVE_PERMS;
    private static final Collection<MicroOperation> BROWSE_PERMS;
    private static final Collection<MicroOperation> LOOKUP_PERMS;
    private static final Collection<MicroOperation> REPLACE_PERMS;
    private static final Collection<MicroOperation> RENAME_PERMS;
    private static final Collection<MicroOperation> EXPORT_PERMS;
    private static final Collection<MicroOperation> IMPORT_PERMS;
    private static final Collection<MicroOperation> MOVERENAME_PERMS;
    private TupleCache tupleCache;
    private GroupCache groupCache;
    private ACIItemParser aciParser;
    private ACDFEngine engine;
    private InterceptorChain chain;
    private String subschemaSubentryDn;
    private PartitionNexus nexus;
    public static final SearchControls DEFAULT_SEARCH_CONTROLS;

    private void initTupleCache() throws LdapException {
        Dn adminDn = new Dn(this.schemaManager, "uid=admin,ou=system");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"prescriptiveACI"});
        EqualityNode<String> filter = new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("accessControlSubentry"));
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), this.directoryService);
        SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, Dn.ROOT_DSE, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor results = this.nexus.search(searchOperationContext);
        try {
            while (results.next()) {
                Entry entry = (Entry)results.get();
                this.tupleCache.subentryAdded(entry.getDn(), entry);
            }
            results.close();
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
    }

    private void initGroupCache() throws LdapException {
        Dn adminDn = new Dn(this.schemaManager, "uid=admin,ou=system");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"member", "uniqueMember"});
        OrNode filter = new OrNode(new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("groupOfNames")), new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("groupOfUniqueNames")));
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), this.directoryService);
        SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, Dn.ROOT_DSE, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor results = this.nexus.search(searchOperationContext);
        try {
            while (results.next()) {
                Entry entry = (Entry)results.get();
                this.groupCache.groupAdded(entry.getDn(), entry);
            }
            results.close();
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initializing the AciAuthorizationInterceptor");
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        Dn adminDn = directoryService.getDnFactory().create("uid=admin,ou=system");
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), directoryService);
        this.chain = directoryService.getInterceptorChain();
        this.tupleCache = new TupleCache(adminSession);
        this.groupCache = new GroupCache(directoryService);
        this.aciParser = new ACIItemParser(new ConcreteNameComponentNormalizer(this.schemaManager), this.schemaManager);
        this.engine = new ACDFEngine(this.schemaManager);
        Value<?> subschemaSubentry = directoryService.getPartitionNexus().getRootDSE(null).get("subschemaSubentry").get();
        Dn subschemaSubentryDnName = directoryService.getDnFactory().create(subschemaSubentry.getString());
        this.subschemaSubentryDn = subschemaSubentryDnName.getNormName();
        this.initTupleCache();
        this.initGroupCache();
    }

    private void protectCriticalEntries(Dn dn) throws LdapException {
        Dn principalDn = AciAuthorizationInterceptor.getPrincipal().getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_8, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = I18n.err(I18n.ERR_9, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    private void addPerscriptiveAciTuples(OperationContext opContext, Collection<ACITuple> tuples, Dn dn, Entry entry) throws LdapException {
        Attribute subentries;
        Entry originalEntry = null;
        originalEntry = entry instanceof ClonedServerEntry ? ((ClonedServerEntry)entry).getOriginalEntry() : entry;
        Attribute oc = originalEntry.get(OBJECT_CLASS_AT);
        if (oc.contains("subentry")) {
            Dn parentDn = dn.getParent();
            originalEntry = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        }
        if ((subentries = originalEntry.get(ACCESS_CONTROL_SUBENTRIES_AT)) == null) {
            return;
        }
        for (Value value : subentries) {
            String subentryDn = value.getString();
            tuples.addAll(this.tupleCache.getACITuples(subentryDn));
        }
    }

    private void addEntryAciTuples(Collection<ACITuple> tuples, Entry entry) throws LdapException {
        Attribute entryAci = entry.get(ENTRY_ACI_AT);
        if (entryAci == null) {
            return;
        }
        for (Value value : entryAci) {
            ACIItem item;
            String aciString = value.getString();
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_10, aciString);
                LOG.error(msg, e);
                throw new LdapOperationErrorException(msg);
            }
            tuples.addAll(item.toTuples());
        }
    }

    private void addSubentryAciTuples(OperationContext opContext, Collection<ACITuple> tuples, Dn dn, Entry entry) throws LdapException {
        if (!entry.contains("objectClass", "subentry")) {
            return;
        }
        Dn parentDn = dn.getParent();
        Entry administrativeEntry = ((ClonedServerEntry)opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY)).getOriginalEntry();
        Attribute subentryAci = administrativeEntry.get(SUBENTRY_ACI_AT);
        if (subentryAci == null) {
            return;
        }
        for (Value value : subentryAci) {
            ACIItem item;
            String aciString = value.getString();
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_11, aciString);
                LOG.error(msg, e);
                throw new LdapOperationErrorException(msg);
            }
            tuples.addAll(item.toTuples());
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        if (!addContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            ACI_LOG.debug("ACI interceptor disabled");
            next.add(addContext);
            return;
        }
        ACI_LOG.debug("Adding the entry {}", addContext.getEntry());
        LdapPrincipal principal = addContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Entry serverEntry = addContext.getEntry();
        Dn dn = addContext.getDn();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            ACI_LOG.debug("Addition done by the administartor : no check");
            next.add(addContext);
            this.tupleCache.subentryAdded(dn, serverEntry);
            this.groupCache.groupAdded(dn, serverEntry);
            return;
        }
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        Entry subentry = subentryInterceptor.getSubentryAttributes(dn, serverEntry);
        for (Attribute attribute : serverEntry) {
            subentry.put(attribute);
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(addContext, tuples, dn, subentry);
        this.addSubentryAciTuples(addContext, tuples, dn, subentry);
        AciContext entryAciCtx = new AciContext(this.schemaManager, addContext);
        entryAciCtx.setUserGroupNames(userGroups);
        entryAciCtx.setUserDn(principalDn);
        entryAciCtx.setAuthenticationLevel(principal.getAuthenticationLevel());
        entryAciCtx.setEntryDn(dn);
        entryAciCtx.setMicroOperations(ADD_PERMS);
        entryAciCtx.setAciTuples(tuples);
        entryAciCtx.setEntry(subentry);
        this.engine.checkPermission(entryAciCtx);
        for (Attribute attribute : serverEntry) {
            for (Value value : attribute) {
                AciContext attrAciContext = new AciContext(this.schemaManager, addContext);
                attrAciContext.setUserGroupNames(userGroups);
                attrAciContext.setUserDn(principalDn);
                attrAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                attrAciContext.setEntryDn(dn);
                attrAciContext.setAttributeType(attribute.getAttributeType());
                attrAciContext.setAttrValue(value);
                attrAciContext.setMicroOperations(ADD_PERMS);
                attrAciContext.setAciTuples(tuples);
                attrAciContext.setEntry(serverEntry);
                this.engine.checkPermission(attrAciContext);
            }
        }
        next.add(addContext);
        this.tupleCache.subentryAdded(dn, serverEntry);
        this.groupCache.groupAdded(dn, serverEntry);
    }

    private boolean isTheAdministrator(Dn normalizedDn) {
        return normalizedDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        CoreSession session = deleteContext.getSession();
        if (!session.getDirectoryService().isAccessControlEnabled()) {
            next.delete(deleteContext);
            return;
        }
        Dn dn = deleteContext.getDn();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Entry entry = deleteContext.getEntry();
        this.protectCriticalEntries(dn);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.delete(deleteContext);
            this.tupleCache.subentryDeleted(dn, entry);
            this.groupCache.groupDeleted(dn, entry);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(deleteContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(deleteContext, tuples, dn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, deleteContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(REMOVE_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        next.delete(deleteContext);
        this.tupleCache.subentryDeleted(dn, entry);
        this.groupCache.groupDeleted(dn, entry);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        LdapPrincipal principal = modifyContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (!modifyContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            next.modify(modifyContext);
            return;
        }
        List<Modification> mods = modifyContext.getModItems();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.modify(modifyContext);
            Entry modifiedEntry = modifyContext.lookup(dn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            this.tupleCache.subentryModified(dn, mods, modifiedEntry);
            this.groupCache.groupModified(dn, mods, entry, this.schemaManager);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(modifyContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(modifyContext, tuples, dn, entry);
        AciContext entryAciContext = new AciContext(this.schemaManager, modifyContext);
        entryAciContext.setUserGroupNames(userGroups);
        entryAciContext.setUserDn(principalDn);
        entryAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        entryAciContext.setEntryDn(dn);
        entryAciContext.setMicroOperations(Collections.singleton(MicroOperation.MODIFY));
        entryAciContext.setAciTuples(tuples);
        entryAciContext.setEntry(entry);
        this.engine.checkPermission(entryAciContext);
        Collection<MicroOperation> perms = null;
        Entry entryView = entry.clone();
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    perms = ADD_PERMS;
                    if (entry.get(attr.getId()) != null) break;
                    AciContext attrAciContext = new AciContext(this.schemaManager, modifyContext);
                    attrAciContext.setUserGroupNames(userGroups);
                    attrAciContext.setUserDn(principalDn);
                    attrAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                    attrAciContext.setEntryDn(dn);
                    attrAciContext.setAttributeType(attr.getAttributeType());
                    attrAciContext.setMicroOperations(perms);
                    attrAciContext.setAciTuples(tuples);
                    attrAciContext.setEntry(entry);
                    this.engine.checkPermission(attrAciContext);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    perms = REMOVE_PERMS;
                    Attribute entryAttr = entry.get(attr.getId());
                    if (entryAttr == null || entryAttr.size() != 1) break;
                    AciContext aciContext = new AciContext(this.schemaManager, modifyContext);
                    aciContext.setUserGroupNames(userGroups);
                    aciContext.setUserDn(principalDn);
                    aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                    aciContext.setEntryDn(dn);
                    aciContext.setAttributeType(attr.getAttributeType());
                    aciContext.setMicroOperations(perms);
                    aciContext.setAciTuples(tuples);
                    aciContext.setEntry(entry);
                    this.engine.checkPermission(aciContext);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    perms = REPLACE_PERMS;
                }
            }
            entryView = ServerEntryUtils.getTargetEntry(mod, entryView, this.schemaManager);
            for (Value value : attr) {
                AciContext aciContext = new AciContext(this.schemaManager, modifyContext);
                aciContext.setUserGroupNames(userGroups);
                aciContext.setUserDn(principalDn);
                aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                aciContext.setEntryDn(dn);
                aciContext.setAttributeType(attr.getAttributeType());
                aciContext.setAttrValue(value);
                aciContext.setMicroOperations(perms);
                aciContext.setAciTuples(tuples);
                aciContext.setEntry(entry);
                aciContext.setEntryView(entryView);
                this.engine.checkPermission(aciContext);
            }
        }
        next.modify(modifyContext);
        Entry modifiedEntry = modifyContext.lookup(dn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        this.tupleCache.subentryModified(dn, mods, modifiedEntry);
        this.groupCache.groupModified(dn, mods, entry, this.schemaManager);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext hasEntryContext) throws LdapException {
        Dn dn = hasEntryContext.getDn();
        if (!hasEntryContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return dn.isRootDSE() || next.hasEntry(hasEntryContext);
        }
        boolean answer = next.hasEntry(hasEntryContext);
        if (dn.isRootDSE()) {
            return answer;
        }
        LdapPrincipal principal = hasEntryContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            return answer;
        }
        Entry entry = hasEntryContext.lookup(dn, ByPassConstants.HAS_ENTRY_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(hasEntryContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, ((ClonedServerEntry)entry).getOriginalEntry());
        this.addSubentryAciTuples(hasEntryContext, tuples, dn, ((ClonedServerEntry)entry).getOriginalEntry());
        AciContext aciContext = new AciContext(this.schemaManager, hasEntryContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(BROWSE_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(((ClonedServerEntry)entry).getOriginalEntry());
        this.engine.checkPermission(aciContext);
        return next.hasEntry(hasEntryContext);
    }

    private void checkLookupAccess(LookupOperationContext lookupContext, Entry entry) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (dn.isRootDSE()) {
            return;
        }
        LdapPrincipal principal = lookupContext.getSession().getEffectivePrincipal();
        Dn userName = principal.getDn();
        Set<Dn> userGroups = this.groupCache.getGroups(userName.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(lookupContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(lookupContext, tuples, dn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, lookupContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(userName);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(LOOKUP_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        for (Attribute attribute : entry) {
            for (Value value : attribute) {
                AciContext valueAciContext = new AciContext(this.schemaManager, lookupContext);
                valueAciContext.setUserGroupNames(userGroups);
                valueAciContext.setUserDn(userName);
                valueAciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                valueAciContext.setEntryDn(dn);
                valueAciContext.setAttributeType(attribute.getAttributeType());
                valueAciContext.setAttrValue(value);
                valueAciContext.setMicroOperations(READ_PERMS);
                valueAciContext.setAciTuples(tuples);
                valueAciContext.setEntry(entry);
                this.engine.checkPermission(valueAciContext);
            }
        }
    }

    @Override
    public Entry lookup(NextInterceptor next, LookupOperationContext lookupContext) throws LdapException {
        CoreSession session = lookupContext.getSession();
        DirectoryService directoryService = session.getDirectoryService();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (!principalDn.isSchemaAware()) {
            principalDn.apply(this.schemaManager);
        }
        if (this.isPrincipalAnAdministrator(principalDn) || !directoryService.isAccessControlEnabled()) {
            return next.lookup(lookupContext);
        }
        lookupContext.setByPassed(ByPassConstants.LOOKUP_BYPASS);
        Entry entry = directoryService.getOperationManager().lookup(lookupContext);
        this.checkLookupAccess(lookupContext, entry);
        return next.lookup(lookupContext);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        Dn oldName = renameContext.getDn();
        Entry originalEntry = null;
        if (renameContext.getEntry() != null) {
            originalEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        }
        LdapPrincipal principal = renameContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Dn newName = renameContext.getNewDn();
        if (!renameContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            next.rename(renameContext);
            return;
        }
        this.protectCriticalEntries(oldName);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.rename(renameContext);
            this.tupleCache.subentryRenamed(oldName, newName);
            this.groupCache.groupRenamed(oldName, newName);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(renameContext, tuples, oldName, originalEntry);
        this.addEntryAciTuples(tuples, originalEntry);
        this.addSubentryAciTuples(renameContext, tuples, oldName, originalEntry);
        AciContext aciContext = new AciContext(this.schemaManager, renameContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(oldName);
        aciContext.setMicroOperations(RENAME_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(originalEntry);
        this.engine.checkPermission(aciContext);
        next.rename(renameContext);
        this.tupleCache.subentryRenamed(oldName, newName);
        this.groupCache.groupRenamed(oldName, newName);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        Entry entry = moveAndRenameContext.getOriginalEntry();
        LdapPrincipal principal = moveAndRenameContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        Dn newDn = moveAndRenameContext.getNewDn();
        if (!moveAndRenameContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            next.moveAndRename(moveAndRenameContext);
            return;
        }
        this.protectCriticalEntries(oldDn);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.moveAndRename(moveAndRenameContext);
            this.tupleCache.subentryRenamed(oldDn, newDn);
            this.groupCache.groupRenamed(oldDn, newDn);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveAndRenameContext, tuples, oldDn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(moveAndRenameContext, tuples, oldDn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, moveAndRenameContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(oldDn);
        aciContext.setMicroOperations(MOVERENAME_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        Entry importedEntry = moveAndRenameContext.lookup(oldDn, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        Entry subentryAttrs = subentryInterceptor.getSubentryAttributes(newDn, importedEntry);
        for (Attribute attribute : importedEntry) {
            subentryAttrs.put(attribute);
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveAndRenameContext, destTuples, newDn, subentryAttrs);
        aciContext = new AciContext(this.schemaManager, moveAndRenameContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(newDn);
        aciContext.setMicroOperations(IMPORT_PERMS);
        aciContext.setAciTuples(destTuples);
        aciContext.setEntry(subentryAttrs);
        this.engine.checkPermission(aciContext);
        next.moveAndRename(moveAndRenameContext);
        this.tupleCache.subentryRenamed(oldDn, newDn);
        this.groupCache.groupRenamed(oldDn, newDn);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        Dn oriChildName = moveContext.getDn();
        Entry entry = moveContext.getOriginalEntry();
        Dn newDn = moveContext.getNewDn();
        LdapPrincipal principal = moveContext.getSession().getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (!moveContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            next.move(moveContext);
            return;
        }
        this.protectCriticalEntries(oriChildName);
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.move(moveContext);
            this.tupleCache.subentryRenamed(oriChildName, newDn);
            this.groupCache.groupRenamed(oriChildName, newDn);
            return;
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveContext, tuples, oriChildName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(moveContext, tuples, oriChildName, entry);
        AciContext aciContext = new AciContext(this.schemaManager, moveContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(oriChildName);
        aciContext.setMicroOperations(EXPORT_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        Entry importedEntry = moveContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        Entry subentryAttrs = subentryInterceptor.getSubentryAttributes(newDn, importedEntry);
        for (Attribute attribute : importedEntry) {
            subentryAttrs.put(attribute);
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(moveContext, destTuples, newDn, subentryAttrs);
        aciContext = new AciContext(this.schemaManager, moveContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(newDn);
        aciContext.setMicroOperations(IMPORT_PERMS);
        aciContext.setAciTuples(destTuples);
        aciContext.setEntry(subentryAttrs);
        this.engine.checkPermission(aciContext);
        next.move(moveContext);
        this.tupleCache.subentryRenamed(oriChildName, newDn);
        this.groupCache.groupRenamed(oriChildName, newDn);
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext listContext) throws LdapException {
        LdapPrincipal user = listContext.getSession().getEffectivePrincipal();
        EntryFilteringCursor cursor = next.list(listContext);
        if (this.isPrincipalAnAdministrator(user.getDn()) || !listContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return cursor;
        }
        AuthorizationFilter authzFilter = new AuthorizationFilter();
        cursor.addEntryFilter(authzFilter);
        return cursor;
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext searchContext) throws LdapException {
        boolean isRootDSELookup;
        LdapPrincipal user = searchContext.getSession().getEffectivePrincipal();
        Dn principalDn = user.getDn();
        EntryFilteringCursor cursor = next.search(searchContext);
        boolean isSubschemaSubentryLookup = this.subschemaSubentryDn.equals(searchContext.getDn().getNormName());
        SearchControls searchCtls = searchContext.getSearchControls();
        boolean bl = isRootDSELookup = searchContext.getDn().size() == 0 && searchCtls.getSearchScope() == 0;
        if (this.isPrincipalAnAdministrator(principalDn) || !searchContext.getSession().getDirectoryService().isAccessControlEnabled() || isRootDSELookup || isSubschemaSubentryLookup) {
            return cursor;
        }
        cursor.addEntryFilter(new AuthorizationFilter());
        return cursor;
    }

    public final boolean isPrincipalAnAdministrator(Dn principalDn) {
        return this.groupCache.isPrincipalAnAdministrator(principalDn);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
        CoreSession session = compareContext.getSession();
        Dn dn = compareContext.getDn();
        String oid = compareContext.getOid();
        Value<?> value = compareContext.getValue();
        Entry entry = compareContext.getOriginalEntry();
        LdapPrincipal principal = session.getEffectivePrincipal();
        Dn principalDn = principal.getDn();
        if (this.isPrincipalAnAdministrator(principalDn) || !session.getDirectoryService().isAccessControlEnabled()) {
            return next.compare(compareContext);
        }
        Set<Dn> userGroups = this.groupCache.getGroups(principalDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(compareContext, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(compareContext, tuples, dn, entry);
        AciContext aciContext = new AciContext(this.schemaManager, compareContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setMicroOperations(READ_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
        aciContext = new AciContext(this.schemaManager, compareContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(principalDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(dn);
        aciContext.setAttributeType(attributeType);
        aciContext.setMicroOperations(COMPARE_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(entry);
        this.engine.checkPermission(aciContext);
        return next.compare(compareContext);
    }

    public void cacheNewGroup(Dn name, Entry entry) throws Exception {
        this.groupCache.groupAdded(name, entry);
    }

    private boolean filter(OperationContext opContext, Dn normName, ClonedServerEntry clonedEntry) throws Exception {
        LdapPrincipal principal = opContext.getSession().getEffectivePrincipal();
        Dn userDn = principal.getDn();
        Set<Dn> userGroups = this.groupCache.getGroups(userDn.getNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(opContext, tuples, normName, clonedEntry);
        this.addEntryAciTuples(tuples, clonedEntry.getOriginalEntry());
        this.addSubentryAciTuples(opContext, tuples, normName, clonedEntry.getOriginalEntry());
        AciContext aciContext = new AciContext(this.schemaManager, opContext);
        aciContext.setUserGroupNames(userGroups);
        aciContext.setUserDn(userDn);
        aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
        aciContext.setEntryDn(normName);
        aciContext.setMicroOperations(SEARCH_ENTRY_PERMS);
        aciContext.setAciTuples(tuples);
        aciContext.setEntry(clonedEntry.getOriginalEntry());
        if (!this.engine.hasPermission(aciContext)) {
            return false;
        }
        ArrayList<AttributeType> attributeToRemove = new ArrayList<AttributeType>();
        for (AttributeType attributeType : clonedEntry.getAttributeTypes()) {
            Attribute attr = clonedEntry.get(attributeType);
            aciContext = new AciContext(this.schemaManager, opContext);
            aciContext.setUserGroupNames(userGroups);
            aciContext.setUserDn(userDn);
            aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
            aciContext.setEntryDn(normName);
            aciContext.setAttributeType(attributeType);
            aciContext.setMicroOperations(SEARCH_ATTRVAL_PERMS);
            aciContext.setAciTuples(tuples);
            aciContext.setEntry(clonedEntry);
            if (!this.engine.hasPermission(aciContext)) {
                attributeToRemove.add(attributeType);
                continue;
            }
            ArrayList<Value> valueToRemove = new ArrayList<Value>();
            for (Value value : attr) {
                aciContext = new AciContext(this.schemaManager, opContext);
                aciContext.setUserGroupNames(userGroups);
                aciContext.setUserDn(userDn);
                aciContext.setAuthenticationLevel(principal.getAuthenticationLevel());
                aciContext.setEntryDn(normName);
                aciContext.setAttributeType(attr.getAttributeType());
                aciContext.setAttrValue(value);
                aciContext.setMicroOperations(SEARCH_ATTRVAL_PERMS);
                aciContext.setAciTuples(tuples);
                aciContext.setEntry(clonedEntry);
                if (this.engine.hasPermission(aciContext)) continue;
                valueToRemove.add(value);
            }
            for (Value value : valueToRemove) {
                attr.remove(value);
            }
            if (attr.size() != 0) continue;
            attributeToRemove.add(attributeType);
        }
        for (AttributeType attributeType : attributeToRemove) {
            clonedEntry.removeAttributes(attributeType);
        }
        return true;
    }

    static {
        HashSet<MicroOperation> set = new HashSet<MicroOperation>(2);
        set.add(MicroOperation.BROWSE);
        set.add(MicroOperation.RETURN_DN);
        SEARCH_ENTRY_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.READ);
        set.add(MicroOperation.BROWSE);
        LOOKUP_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.ADD);
        set.add(MicroOperation.REMOVE);
        REPLACE_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.EXPORT);
        set.add(MicroOperation.RENAME);
        MOVERENAME_PERMS = Collections.unmodifiableCollection(set);
        SEARCH_ATTRVAL_PERMS = Collections.singleton(MicroOperation.READ);
        ADD_PERMS = Collections.singleton(MicroOperation.ADD);
        READ_PERMS = Collections.singleton(MicroOperation.READ);
        COMPARE_PERMS = Collections.singleton(MicroOperation.COMPARE);
        REMOVE_PERMS = Collections.singleton(MicroOperation.REMOVE);
        BROWSE_PERMS = Collections.singleton(MicroOperation.BROWSE);
        RENAME_PERMS = Collections.singleton(MicroOperation.RENAME);
        EXPORT_PERMS = Collections.singleton(MicroOperation.EXPORT);
        IMPORT_PERMS = Collections.singleton(MicroOperation.IMPORT);
        DEFAULT_SEARCH_CONTROLS = new SearchControls();
    }

    private class AuthorizationFilter
    implements EntryFilter {
        private AuthorizationFilter() {
        }

        public boolean accept(SearchingOperationContext searchContext, Entry entry) throws Exception {
            Dn normName = entry.getDn().apply(AciAuthorizationInterceptor.this.schemaManager);
            return AciAuthorizationInterceptor.this.filter(searchContext, normName, (ClonedServerEntry)entry);
        }
    }
}

