/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import org.apache.directory.shared.util.Base64;
import org.apache.directory.shared.util.DateUtils;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordHistory
implements Comparable<PasswordHistory> {
    private String time;
    private String syntaxOID = "1.3.6.1.4.1.1466.115.121.1.40";
    private int length;
    private String data;
    private static final char DELIMITER = '#';

    public PasswordHistory(String pwdHistoryVal) {
        int pos = pwdHistoryVal.indexOf(35);
        this.time = pwdHistoryVal.substring(0, pos);
        int nextPos = pwdHistoryVal.indexOf(35, ++pos);
        this.syntaxOID = pwdHistoryVal.substring(pos, nextPos);
        pos = pwdHistoryVal.indexOf(35, ++nextPos);
        this.length = Integer.parseInt(pwdHistoryVal.substring(nextPos, pos));
        this.data = pwdHistoryVal.substring(pos + 1);
    }

    public PasswordHistory(String time, byte[] password) {
        this.time = time;
        this.data = String.valueOf(Base64.encode(password));
        this.length = this.data.length();
    }

    public byte[] getHistoryValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.time).append('#');
        sb.append(this.syntaxOID).append('#');
        sb.append(this.length).append('#');
        sb.append(this.data);
        return Strings.getBytesUtf8(sb.toString());
    }

    public String getTime() {
        return this.time;
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getPassword() {
        return Base64.decode(this.data.toCharArray());
    }

    @Override
    public int compareTo(PasswordHistory o) {
        return o.getTime().compareTo(this.time);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PasswordHistory)) {
            return false;
        }
        PasswordHistory other = (PasswordHistory)o;
        return this.getTime().equals(other.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + (this.syntaxOID == null ? 0 : this.syntaxOID.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        return result;
    }

    public String toString() {
        return "PasswordHistory [time=" + this.time + ", syntaxOID=" + this.syntaxOID + ", length=" + this.length + ", data=" + this.data + "]";
    }

    public static void main(String[] args) {
        byte[] pwdhBytes = new PasswordHistory(DateUtils.getGeneralizedTime(), "secret".getBytes()).getHistoryValue();
        PasswordHistory pwdHistory = new PasswordHistory(Strings.utf8ToString(pwdhBytes));
        System.out.println(pwdHistory);
    }
}

