/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.administrative;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.server.core.administrative.AdministrativePoint;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.subtree.AdministrativeRole;

public abstract class AbstractAdministrativePoint
implements AdministrativePoint {
    protected Dn dn;
    protected String uuid;
    protected AdministrativeRole role;
    protected AdministrativePoint parent;
    protected Map<String, AdministrativePoint> children;

    protected AbstractAdministrativePoint(Dn dn, String uuid, AdministrativeRole role) {
        this.dn = dn;
        this.uuid = uuid;
        this.role = role;
        this.children = new ConcurrentHashMap<String, AdministrativePoint>();
    }

    public AdministrativeRole getRole() {
        return this.role;
    }

    public Dn getDn() {
        return this.dn;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isAutonomous() {
        return false;
    }

    public abstract boolean isInner();

    public abstract boolean isSpecific();

    public AdministrativePoint getParent() {
        return this.parent;
    }

    public void setParent(AdministrativePoint parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Role: '").append((Object)this.role).append("', ");
        sb.append("Dn: '").append(this.dn).append("', ");
        sb.append("UUID: ").append(this.uuid).append('\n');
        return sb.toString();
    }
}

