/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.File;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import org.apache.directory.server.core.DirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService {
    private static final String DIRECTORY_CACHESERVICE_XML = "directory-cacheservice.xml";
    private static final Logger LOG = LoggerFactory.getLogger(CacheService.class);
    private CacheManager cacheManager;

    protected CacheService() {
    }

    public void initialize(DirectoryService dirService) {
        if (this.cacheManager != null && this.cacheManager.getStatus() == Status.STATUS_ALIVE) {
            LOG.warn("cache service was already initialized and is alive");
            return;
        }
        File configFile = new File(dirService.getInstanceLayout().getConfDirectory(), DIRECTORY_CACHESERVICE_XML);
        if (!configFile.exists()) {
            LOG.info("no custom cache configuration was set, loading the default cache configuration");
            this.cacheManager = new CacheManager(this.getClass().getClassLoader().getResource(DIRECTORY_CACHESERVICE_XML));
        } else {
            LOG.info("loading cache configuration from the file {}", configFile);
            this.cacheManager = new CacheManager(configFile.getAbsolutePath());
        }
    }

    public void destroy() {
        LOG.info("clearing all the caches");
        this.cacheManager.clearAll();
        this.cacheManager.shutdown();
    }

    public Cache getCache(String name) {
        LOG.info("fetching the cache named {}", (Object)name);
        return this.cacheManager.getCache(name);
    }
}

