/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.AdsBaseBean;

public class TransportBean
extends AdsBaseBean {
    private static final int DEFAULT_BACKLOG_NB = 50;
    private static final int DEFAULT_NB_THREADS = 3;
    @ConfigurationElement(attributeType="ads-transportId", isRdn=true)
    private String transportId;
    @ConfigurationElement(attributeType="ads-transportAddress")
    private String transportAddress;
    @ConfigurationElement(attributeType="ads-systemPort")
    private int systemPort = -1;
    @ConfigurationElement(attributeType="ads-transportEnableSsl", isOptional=true, defaultValue="false")
    private boolean transportEnableSsl = false;
    @ConfigurationElement(attributeType="ads-transportNbThreads", isOptional=true, defaultValue="3")
    private int transportNbThreads = 3;
    @ConfigurationElement(attributeType="ads-transportBackLog", isOptional=true, defaultValue="50")
    private int transportBackLog = 50;

    public void setSystemPort(int systemPort) {
        this.systemPort = systemPort;
    }

    public int getSystemPort() {
        return this.systemPort;
    }

    public void setTransportAddress(String transportAddress) {
        this.transportAddress = transportAddress;
    }

    public String getTransportAddress() {
        return this.transportAddress;
    }

    public boolean isTransportEnableSSL() {
        return this.transportEnableSsl;
    }

    public void setTransportEnableSSL(boolean transportEnableSSL) {
        this.transportEnableSsl = transportEnableSSL;
    }

    public int getTransportNbThreads() {
        return this.transportNbThreads;
    }

    public void setTransportNbThreads(int transportNbThreads) {
        this.transportNbThreads = transportNbThreads;
    }

    public int getTransportBackLog() {
        return this.transportBackLog;
    }

    public void setTransportBackLog(int transportBacklog) {
        this.transportBackLog = transportBacklog;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString(tabs, "transport id", this.transportId));
        sb.append(tabs).append("transport address : ");
        if (this.transportAddress == null) {
            sb.append("localhost").append('\n');
        } else {
            sb.append(this.transportAddress).append('\n');
        }
        sb.append(tabs).append("transport port : ").append(this.systemPort).append('\n');
        sb.append(tabs).append("transport backlog : ").append(this.transportBackLog).append('\n');
        sb.append(tabs).append("transport nb threads : ").append(this.transportNbThreads).append('\n');
        sb.append(this.toString(tabs, "SSL enabled", this.transportEnableSsl));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

