/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.io.InputStream;
import java.util.Iterator;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.impl.avl.AvlPartition;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.xdbm.impl.avl.AvlStore;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ReadOnlyConfigurationPartition
extends AbstractLdifPartition {
    private InputStream inputStream;

    public ReadOnlyConfigurationPartition(InputStream inputStream, SchemaManager schemaManager) {
        this.inputStream = inputStream;
        this.setSchemaManager(schemaManager);
    }

    protected void doInit() throws InvalidNameException, Exception {
        this.setWrappedPartition(new AvlPartition());
        this.setId("config");
        this.setSuffix(new Dn("ou=config"));
        this.wrappedPartition.setSchemaManager(this.schemaManager);
        this.wrappedPartition.initialize();
        this.searchEngine = this.wrappedPartition.getSearchEngine();
        this.loadLdifEntries();
    }

    private void loadLdifEntries() throws Exception {
        if (this.inputStream != null) {
            LdifReader reader = new LdifReader(this.inputStream);
            Iterator<LdifEntry> itr = reader.iterator();
            if (!itr.hasNext()) {
                return;
            }
            AvlStore<Entry> store = this.wrappedPartition.getStore();
            LdifEntry ldifEntry = itr.next();
            this.contextEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            if (this.suffix.equals(this.contextEntry.getDn())) {
                this.addMandatoryOpAt(this.contextEntry);
                store.add(this.contextEntry);
            } else {
                throw new LdapException("The given LDIF file doesn't contain the context entry");
            }
            while (itr.hasNext()) {
                DefaultEntry entry = new DefaultEntry(this.schemaManager, itr.next().getEntry());
                this.addMandatoryOpAt(entry);
                store.add(entry);
            }
            reader.close();
        }
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", defaultCSNFactory.newInstance().toString());
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", uuid);
        }
    }

    public void bind(BindOperationContext bindContext) throws LdapException {
        this.wrappedPartition.bind(bindContext);
    }

    public void add(AddOperationContext arg0) throws LdapException {
    }

    public void delete(Long arg0) throws LdapException {
    }

    public void modify(ModifyOperationContext arg0) throws LdapException {
    }

    public void move(MoveOperationContext arg0) throws LdapException {
    }

    public void moveAndRename(MoveAndRenameOperationContext arg0) throws LdapException {
    }

    public void rename(RenameOperationContext arg0) throws LdapException {
    }
}

