/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import org.apache.directory.server.i18n.I18n;

public class PageHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_NEXT = 2;
    private static final short O_PREV = 10;
    protected static final short SIZE = 18;
    protected BlockIo block;

    protected PageHeader(BlockIo block) {
        this.block = block;
        block.setView(this);
        if (!this.magicOk()) {
            throw new Error(I18n.err(I18n.ERR_546, block.getBlockId(), this.getMagic()));
        }
    }

    PageHeader(BlockIo block, short type) {
        this.block = block;
        block.setView(this);
        this.setType(type);
    }

    static PageHeader getView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof PageHeader) {
            return (PageHeader)view;
        }
        return new PageHeader(block);
    }

    private boolean magicOk() {
        short magic = this.getMagic();
        return magic >= 4945 && magic <= 4949;
    }

    protected void paranoiaMagicOk() {
        if (!this.magicOk()) {
            throw new Error(I18n.err(I18n.ERR_547, this.getMagic()));
        }
    }

    short getMagic() {
        return this.block.readShort(0);
    }

    long getNext() {
        this.paranoiaMagicOk();
        return this.block.readLong(2);
    }

    void setNext(long next) {
        this.paranoiaMagicOk();
        this.block.writeLong(2, next);
    }

    long getPrev() {
        this.paranoiaMagicOk();
        return this.block.readLong(10);
    }

    void setPrev(long prev) {
        this.paranoiaMagicOk();
        this.block.writeLong(10, prev);
    }

    void setType(short type) {
        this.block.writeShort(0, (short)(4945 + type));
    }
}

