/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDS {
    private static final Logger LOG = LoggerFactory.getLogger((String)ApacheDS.class.getName());
    private static final long DEFAULT_SYNC_PERIOD_MILLIS = 20000L;
    private long synchPeriodMillis = 20000L;
    private File ldifDirectory;
    private final List<LdifLoadFilter> ldifFilters = new ArrayList<LdifLoadFilter>();
    private final LdapServer ldapServer;
    private final LdapServer ldapsServer;
    private final DirectoryService directoryService;

    public ApacheDS(DirectoryService directoryService, LdapServer ldapServer, LdapServer ldapsServer) {
        LOG.info("Starting the Apache Directory Server");
        this.directoryService = directoryService == null ? new DefaultDirectoryService() : directoryService;
        this.ldapServer = ldapServer;
        this.ldapsServer = ldapsServer;
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)false);
    }

    public void startup() throws NamingException, IOException {
        LOG.debug("Starting the server");
        if (!this.directoryService.isStarted()) {
            LOG.debug("1. Starting the DirectoryService");
            this.directoryService.startup();
        }
        this.loadLdifs();
        if (this.ldapServer != null && !this.ldapServer.isStarted()) {
            LOG.debug("3. Starting the LDAP server");
            this.ldapServer.start();
        }
        if (this.ldapsServer != null && !this.ldapsServer.isStarted()) {
            LOG.debug("4. Starting the LDAPS server");
            this.ldapsServer.start();
        }
        LOG.debug("Server successfully started");
    }

    public boolean isStarted() {
        if (this.ldapServer != null || this.ldapsServer != null) {
            return this.ldapServer != null && this.ldapServer.isStarted() || this.ldapsServer != null && this.ldapsServer.isStarted();
        }
        return this.directoryService.isStarted();
    }

    public void shutdown() throws NamingException {
        if (this.ldapServer != null && this.ldapServer.isStarted()) {
            this.ldapServer.stop();
        }
        if (this.ldapsServer != null && this.ldapsServer.isStarted()) {
            this.ldapsServer.stop();
        }
        this.directoryService.shutdown();
    }

    public LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public LdapServer getLdapsServer() {
        return this.ldapsServer;
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public long getSynchPeriodMillis() {
        return this.synchPeriodMillis;
    }

    public void setSynchPeriodMillis(long synchPeriodMillis) {
        LOG.info("Set the synchPeriodMillis to {}", (Object)synchPeriodMillis);
        this.synchPeriodMillis = synchPeriodMillis;
    }

    public File getLdifDirectory() {
        return this.ldifDirectory;
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        LOG.info("Set the allowAnonymousAccess flag to {}", (Object)allowAnonymousAccess);
        this.directoryService.setAllowAnonymousAccess(allowAnonymousAccess);
        if (this.ldapServer != null) {
            this.ldapServer.setAllowAnonymousAccess(allowAnonymousAccess);
        }
        if (this.ldapsServer != null) {
            this.ldapsServer.setAllowAnonymousAccess(allowAnonymousAccess);
        }
    }

    public void setLdifDirectory(File ldifDirectory) {
        LOG.info("The LDIF directory file is {}", (Object)ldifDirectory.getAbsolutePath());
        this.ldifDirectory = ldifDirectory;
    }

    private void ensureLdifFileBase(DirContext root) {
        AttributesImpl entry = new AttributesImpl("ou", (Object)"loadedLdifFiles", true);
        entry.put("objectClass", "top");
        entry.get("objectClass").add("organizationalUnit");
        try {
            root.createSubcontext("ou=loadedLdifFiles,ou=configuration,ou=system", (Attributes)entry);
            LOG.info("Creating ou=loadedLdifFiles,ou=configuration,ou=system");
        }
        catch (NamingException e) {
            LOG.info("ou=loadedLdifFiles,ou=configuration,ou=system exists");
        }
    }

    private String buildProtectedFileEntry(File ldif) {
        String fileSep = File.separatorChar == '\\' ? "windowsFilePath" : "unixFilePath";
        return fileSep + "=" + StringTools.dumpHexPairs((byte[])StringTools.getBytesUtf8((String)this.getCanonical(ldif))) + "," + "ou=loadedLdifFiles,ou=configuration,ou=system";
    }

    private void addFileEntry(DirContext root, File ldif) throws NamingException {
        String rdnAttr = File.separatorChar == '\\' ? "windowsFilePath" : "unixFilePath";
        String oc = File.separatorChar == '\\' ? "windowsFile" : "unixFile";
        AttributesImpl entry = new AttributesImpl(rdnAttr, (Object)this.getCanonical(ldif), true);
        entry.put("objectClass", "top");
        entry.get("objectClass").add(oc);
        root.createSubcontext(this.buildProtectedFileEntry(ldif), (Attributes)entry);
    }

    private Attributes getLdifFileEntry(DirContext root, File ldif) {
        try {
            return root.getAttributes(this.buildProtectedFileEntry(ldif), new String[]{"createTimestamp"});
        }
        catch (NamingException e) {
            return null;
        }
    }

    private String getCanonical(File file) {
        String canonical;
        try {
            canonical = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error("could not get canonical path", (Throwable)e);
            return null;
        }
        return StringUtils.replace((String)canonical, (String)"\\", (String)"\\\\");
    }

    private void loadLdif(DirContext root, File ldifFile) throws NamingException {
        Attributes fileEntry = this.getLdifFileEntry(root, ldifFile);
        if (fileEntry != null) {
            String time = (String)fileEntry.get("createTimestamp").get();
            LOG.info("Load of LDIF file '" + this.getCanonical(ldifFile) + "' skipped.  It has already been loaded on " + time + ".");
        } else {
            LdifFileLoader loader = new LdifFileLoader(root, ldifFile, this.ldifFilters);
            int count = loader.execute();
            LOG.info("Loaded " + count + " entries from LDIF file '" + this.getCanonical(ldifFile) + "'");
            this.addFileEntry(root, ldifFile);
        }
    }

    public void loadLdifs() throws NamingException {
        if (this.ldifDirectory == null) {
            LOG.info("LDIF load directory not specified.  No LDIF files will be loaded.");
            return;
        }
        if (!this.ldifDirectory.exists()) {
            LOG.warn("LDIF load directory '{}' does not exist.  No LDIF files will be loaded.", (Object)this.getCanonical(this.ldifDirectory));
            return;
        }
        LdapDN dn = new LdapDN("uid=admin,ou=system");
        AttributeTypeRegistry reg = this.directoryService.getRegistries().getAttributeTypeRegistry();
        dn.normalize(reg.getNormalizerMapping());
        LdapPrincipal admin = new LdapPrincipal(dn, AuthenticationLevel.STRONG);
        LdapContext root = this.directoryService.getJndiContext(admin);
        this.ensureLdifFileBase(root);
        if (this.ldifDirectory.isFile()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LDIF load directory '{}' is a file. Will attempt to load as LDIF.", (Object)this.getCanonical(this.ldifDirectory));
            }
            try {
                this.loadLdif(root, this.ldifDirectory);
            }
            catch (NamingException ne) {
                LOG.error("Cannot load the ldif file '{}', error : ", (Object)this.ldifDirectory.getAbsolutePath(), (Object)ne.getMessage());
                throw ne;
            }
        } else {
            File[] ldifFiles = this.ldifDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    boolean isLdif = pathname.getName().toLowerCase().endsWith(".ldif");
                    return pathname.isFile() && pathname.canRead() && isLdif;
                }
            });
            if (ldifFiles == null || ldifFiles.length == 0) {
                LOG.warn("LDIF load directory '{}' does not contain any LDIF files. No LDIF files will be loaded.", (Object)this.getCanonical(this.ldifDirectory));
                return;
            }
            for (File ldifFile : ldifFiles) {
                try {
                    LOG.info("Loading LDIF file '{}'", (Object)ldifFile.getName());
                    this.loadLdif(root, ldifFile);
                }
                catch (NamingException ne) {
                    LOG.error("Cannot load the ldif file '{}', error : {}", (Object)ldifFile.getAbsolutePath(), (Object)ne.getMessage());
                    throw ne;
                }
            }
        }
    }
}

