/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.ConfigurationUtil;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;

public class ServerStartupConfiguration
extends StartupConfiguration {
    private static final long serialVersionUID = -7138616822614155454L;
    private boolean enableNetworking = true;
    private int ldapPort = 389;
    private int ldapsPort = 636;
    private File ldapsCertificateFile = new File(this.getWorkingDirectory().getPath() + File.separator + "certificates" + File.separator + "server.cert");
    private String ldapsCertificatePassword = "changeit";
    private boolean enableLdaps = false;
    private boolean enableKerberos = false;
    private boolean enableChangePassword = false;
    private boolean enableNtp = false;
    private final Collection extendedOperationHandlers = new ArrayList();
    private File ldifDirectory = null;
    private final List ldifFilters = new ArrayList();

    protected ServerStartupConfiguration() {
    }

    public boolean isEnableNetworking() {
        return this.enableNetworking;
    }

    public void setEnableNetworking(boolean enableNetworking) {
        this.enableNetworking = enableNetworking;
    }

    public boolean isEnableKerberos() {
        return this.enableKerberos;
    }

    public boolean isEnableChangePassword() {
        return this.enableChangePassword;
    }

    public boolean isEnableNtp() {
        return this.enableNtp;
    }

    protected void setEnableKerberos(boolean enableKerberos) {
        this.enableKerberos = enableKerberos;
    }

    protected void setEnableChangePassword(boolean enableChangePassword) {
        this.enableChangePassword = enableChangePassword;
    }

    protected void setEnableNtp(boolean enableNtp) {
        this.enableNtp = enableNtp;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    protected void setLdapPort(int ldapPort) {
        ConfigurationUtil.validatePortNumber((int)ldapPort);
        this.ldapPort = ldapPort;
    }

    public int getLdapsPort() {
        return this.ldapsPort;
    }

    protected void setLdapsPort(int ldapsPort) {
        ConfigurationUtil.validatePortNumber((int)ldapsPort);
        this.ldapsPort = ldapsPort;
    }

    public boolean isEnableLdaps() {
        return this.enableLdaps;
    }

    protected void setEnableLdaps(boolean enableLdaps) {
        this.enableLdaps = enableLdaps;
    }

    public File getLdapsCertificateFile() {
        return this.ldapsCertificateFile;
    }

    protected void setLdapsCertificateFile(File ldapsCertificateFile) {
        if (ldapsCertificateFile == null) {
            throw new ConfigurationException("LdapsCertificateFile cannot be null.");
        }
        this.ldapsCertificateFile = ldapsCertificateFile;
    }

    public String getLdapsCertificatePassword() {
        return this.ldapsCertificatePassword;
    }

    protected void setLdapsCertificatePassword(String ldapsCertificatePassword) {
        if (ldapsCertificatePassword == null) {
            throw new ConfigurationException("LdapsCertificatePassword cannot be null.");
        }
        this.ldapsCertificatePassword = ldapsCertificatePassword;
    }

    public Collection getExtendedOperationHandlers() {
        return new ArrayList(this.extendedOperationHandlers);
    }

    protected void setExtendedOperationHandlers(Collection handlers) {
        Iterator i = handlers.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof ExtendedOperationHandler) continue;
            throw new IllegalArgumentException("The specified handler collection contains an element which is not an ExtendedOperationHandler.");
        }
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public File getLdifDirectory() {
        return this.ldifDirectory;
    }

    protected void setLdifDirectory(File ldifDirectory) {
        this.ldifDirectory = ldifDirectory;
    }

    public List getLdifFilters() {
        return new ArrayList(this.ldifFilters);
    }

    protected void setLdifFilters(List filters) {
        for (int ii = 0; ii < filters.size(); ++ii) {
            if (filters.get(ii) instanceof LdifLoadFilter) continue;
            throw new IllegalArgumentException("The specified filter collection contains an element which is not an LdifLoadFilter.");
        }
        this.ldifFilters.clear();
        this.ldifFilters.addAll(filters);
    }
}

