/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNormalizerRegistry
implements NormalizerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNormalizerRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final Map<String, Normalizer> byOid = new HashMap<String, Normalizer>();
    private final Map<String, NormalizerDescription> oidToDescription = new HashMap<String, NormalizerDescription>();

    @Override
    public void register(NormalizerDescription description, Normalizer normalizer) throws NamingException {
        String oid = description.getNumericOid();
        if (this.byOid.containsKey(oid)) {
            throw new NamingException("Normalizer already registered for OID " + oid);
        }
        this.oidToDescription.put(oid, description);
        this.byOid.put(oid, normalizer);
        if (DEBUG) {
            LOG.debug("registered normalizer with oid: " + oid);
        }
    }

    @Override
    public Normalizer lookup(String oid) throws NamingException {
        if (!this.byOid.containsKey(oid)) {
            throw new NamingException("Normalizer for OID " + oid + " does not exist!");
        }
        Normalizer normalizer = this.byOid.get(oid);
        if (DEBUG) {
            LOG.debug("registered normalizer with oid: " + oid);
        }
        return normalizer;
    }

    @Override
    public boolean hasNormalizer(String oid) {
        return this.byOid.containsKey(oid);
    }

    @Override
    public String getSchemaName(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        if (this.oidToDescription.containsKey(oid)) {
            return DefaultNormalizerRegistry.getSchema(this.oidToDescription.get(oid));
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }

    private static String getSchema(NormalizerDescription desc) {
        List values = (List)desc.getExtensions().get("X-SCHEMA");
        if (values == null || values.size() == 0) {
            return "other";
        }
        return (String)((List)desc.getExtensions().get("X-SCHEMA")).get(0);
    }

    @Override
    public Iterator<String> oidIterator() {
        return this.byOid.keySet().iterator();
    }

    @Override
    public void unregister(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("OID " + oid + " is not a numeric OID");
        }
        this.byOid.remove(oid);
        this.oidToDescription.remove(oid);
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOid.keySet());
        for (String oid : oids) {
            NormalizerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultNormalizerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(schemaName)) continue;
            this.byOid.remove(oid);
            this.oidToDescription.remove(oid);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOid.keySet());
        for (String oid : oids) {
            NormalizerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultNormalizerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(originalSchemaName)) continue;
            List schemaExt = (List)description.getExtensions().get("X-SCHEMA");
            schemaExt.clear();
            schemaExt.add(newSchemaName);
        }
    }

    @Override
    public Iterator<NormalizerDescription> normalizerDescriptionIterator() {
        return this.oidToDescription.values().iterator();
    }
}

