/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectClassRegistry
implements ObjectClassRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultObjectClassRegistry.class);
    private final Map<String, ObjectClass> byOid = new HashMap<String, ObjectClass>();
    private final OidRegistry oidRegistry;

    public DefaultObjectClassRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(ObjectClass objectClass) throws NamingException {
        if (this.byOid.containsKey(objectClass.getOid())) {
            NamingException e = new NamingException("objectClass w/ OID " + objectClass.getOid() + " has already been registered!");
            throw e;
        }
        if (objectClass.getNames() != null && objectClass.getNames().length > 0) {
            this.oidRegistry.register(objectClass.getName(), objectClass.getOid());
        } else {
            this.oidRegistry.register(objectClass.getOid(), objectClass.getOid());
        }
        this.byOid.put(objectClass.getOid(), objectClass);
        if (log.isDebugEnabled()) {
            log.debug("registered objectClass: " + objectClass);
        }
    }

    @Override
    public ObjectClass lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("objectClass w/ OID " + id + " not registered!");
            throw e;
        }
        ObjectClass objectClass = this.byOid.get(id);
        if (log.isDebugEnabled()) {
            log.debug("looked objectClass with OID '" + id + "' and got back " + objectClass);
        }
        return objectClass;
    }

    @Override
    public boolean hasObjectClass(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        ObjectClass oc = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (oc != null) {
            return oc.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "ObjectClass map!");
    }

    @Override
    public Iterator<ObjectClass> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
    }
}

