
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the nis schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class NisAttributeTypeProducer extends AbstractBootstrapProducer
{

    public NisAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.0 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.0", registries );
        attributeType.setDescription( "An integer uniquely identifying a user in an administrative domain" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "uidNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.0", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.1", registries );
        attributeType.setDescription( "An integer uniquely identifying a group in an administrative domain" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "gidNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.2", registries );
        attributeType.setDescription( "The GECOS field; the common name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "gecos" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.3", registries );
        attributeType.setDescription( "The absolute path to the home directory" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "homeDirectory" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.4", registries );
        attributeType.setDescription( "The path to the login shell" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "loginShell" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.5", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowLastChange" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.6", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowMin" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.7", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowMax" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.8", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowWarning" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.9", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowInactive" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.10", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowExpire" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.11 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.11", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "shadowFlag" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.11", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.12", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSubstrId( "caseExactIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "memberUid" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.13", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSubstrId( "caseExactIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "memberNisNetgroup" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.14 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.14", registries );
        attributeType.setDescription( "Netgroup triple" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.1.1.0.0" );

        names.clear();
        names.add( "nisNetgroupTriple" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.14", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.15 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.15", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "ipServicePort" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.15", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.16 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.16", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "ipServiceProtocol" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.16", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.17 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.17", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "ipProtocolNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.17", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.18 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.18", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "integerMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.27" );

        names.clear();
        names.add( "oncRpcNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.18", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.19 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.19", registries );
        attributeType.setDescription( "IP address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "ipHostNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.19", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.20 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.20", registries );
        attributeType.setDescription( "IP network" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "ipNetworkNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.20", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.21 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.21", registries );
        attributeType.setDescription( "IP netmask" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "ipNetmaskNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.21", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.22 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.22", registries );
        attributeType.setDescription( "MAC address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "macAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.22", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.23 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.23", registries );
        attributeType.setDescription( "rpc.bootparamd parameter" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.1.1.0.1" );

        names.clear();
        names.add( "bootParameter" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.23", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.24 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.24", registries );
        attributeType.setDescription( "Boot image name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "bootFile" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.24", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.26 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.26", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "nisMapName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.26", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.3.6.1.1.1.1.27 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.3.6.1.1.1.1.27", registries );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 1024 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseExactIA5Match" );
        attributeType.setSubstrId( "caseExactIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "nisMapEntry" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.1.1.1.27", attributeType );
    }
}
