
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.Registries;


/**
 * A producer of schema objectClass definations for the inetorgperson schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class InetorgpersonObjectClassProducer extends AbstractBootstrapProducer
{

    public InetorgpersonObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        // --------------------------------------------------------------------
        // ObjectClass 2.16.840.1.113730.3.2.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "2.16.840.1.113730.3.2.2", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2798: Internet Organizational Person" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );

        // set superior objectClasses
        array.clear();
        array.add( "organizationalPerson" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );

        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );

        // set may list
        array.clear();
        array.add( "audio" );
        array.add( "businessCategory" );
        array.add( "carLicense" );
        array.add( "departmentNumber" );
        array.add( "displayName" );
        array.add( "employeeNumber" );
        array.add( "employeeType" );
        array.add( "givenName" );
        array.add( "homePhone" );
        array.add( "homePostalAddress" );
        array.add( "initials" );
        array.add( "jpegPhoto" );
        array.add( "labeledURI" );
        array.add( "mail" );
        array.add( "manager" );
        array.add( "mobile" );
        array.add( "o" );
        array.add( "pager" );
        array.add( "photo" );
        array.add( "roomNumber" );
        array.add( "secretary" );
        array.add( "uid" );
        array.add( "userCertificate" );
        array.add( "x500uniqueIdentifier" );
        array.add( "preferredLanguage" );
        array.add( "userSMIMECertificate" );
        array.add( "userPKCS12" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );

        // set names
        array.clear();
        array.add( "inetOrgPerson" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.2.2", objectClass );
    }
}
