
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the inetorgperson schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class InetorgpersonAttributeTypeProducer extends AbstractBootstrapProducer
{

    public InetorgpersonAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.1", registries );
        attributeType.setDescription( "RFC2798: vehicle license or registration plate" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "carLicense" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.2", registries );
        attributeType.setDescription( "RFC2798: identifies a department within an organization" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "departmentNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.241 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.241", registries );
        attributeType.setDescription( "RFC2798: preferred name to be used when displaying entries" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "displayName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.241", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.3", registries );
        attributeType.setDescription( "RFC2798: numerically identifies an employee within an organization" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "employeeNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.4", registries );
        attributeType.setDescription( "RFC2798: type of employment for a person" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "employeeType" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.60 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.60", registries );
        attributeType.setDescription( "RFC2798: a JPEG image" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.28" );

        names.clear();
        names.add( "jpegPhoto" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.60", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.39 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.39", registries );
        attributeType.setDescription( "RFC2798: preferred written or spoken language for a person" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "preferredLanguage" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.39", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.40 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.40", registries );
        attributeType.setDescription( "RFC2798: PKCS#7 SignedData used to support S/MIME" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.5" );

        names.clear();
        names.add( "userSMIMECertificate" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.40", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.16.840.1.113730.3.1.216 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.16.840.1.113730.3.1.216", registries );
        attributeType.setDescription( "RFC2798: personal identity information, a PKCS #12 PFX" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.5" );

        names.clear();
        names.add( "userPKCS12" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.16.840.1.113730.3.1.216", attributeType );
    }
}
