/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifFileLoader {
    private static final Logger log = LoggerFactory.getLogger(LdifFileLoader.class);
    protected DirContext ctx;
    protected File ldif;
    protected final List<LdifLoadFilter> filters;
    protected final ClassLoader loader;
    private int count;

    public LdifFileLoader(DirContext ctx, String ldif) {
        this(ctx, new File(ldif), null);
    }

    public LdifFileLoader(DirContext ctx, File ldif, List<? extends LdifLoadFilter> filters) {
        this(ctx, ldif, filters, null);
    }

    public LdifFileLoader(DirContext ctx, File ldif, List<? extends LdifLoadFilter> filters, ClassLoader loader) {
        this.ctx = ctx;
        this.ldif = ldif;
        this.loader = loader;
        this.filters = filters == null ? Collections.emptyList() : Collections.unmodifiableList(filters);
    }

    private boolean applyFilters(String dn, Attributes entry) {
        boolean accept = true;
        int limit = this.filters.size();
        if (limit == 0) {
            return true;
        }
        for (int ii = 0; ii < limit; ++ii) {
            try {
                accept &= this.filters.get(ii).filter(this.ldif, dn, entry, this.ctx);
            }
            catch (NamingException e) {
                log.warn("filter " + this.filters.get(ii) + " was bypassed due to failures", (Throwable)e);
            }
            if (accept) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        Name rdn = null;
        InputStream in = null;
        try {
            in = this.getLdifStream();
            for (LdifEntry ldifEntry : new LdifReader(new BufferedReader(new InputStreamReader(in)))) {
                String dn = ldifEntry.getDn();
                if (ldifEntry.isEntry()) {
                    Attributes attributes = ldifEntry.getAttributes();
                    boolean filterAccepted = this.applyFilters(dn, attributes);
                    if (!filterAccepted) continue;
                    rdn = this.getRelativeName(this.ctx, dn);
                    try {
                        this.ctx.lookup(rdn);
                        log.info("Found {}, will not create.", (Object)rdn);
                    }
                    catch (Exception e) {
                        try {
                            this.ctx.createSubcontext(rdn, attributes);
                            ++this.count;
                            log.info("Created {}.", (Object)rdn);
                        }
                        catch (NamingException e1) {
                            log.info("Could not create: " + dn + " with attributes: " + attributes, (Throwable)e1);
                        }
                    }
                    continue;
                }
                List items = ldifEntry.getModificationItems();
                try {
                    this.ctx.modifyAttributes(dn, items.toArray(new ModificationItem[items.size()]));
                    log.info("Modified: " + dn + " with modificationItems: " + items);
                }
                catch (NamingException e) {
                    log.info("Could not modify: " + dn + " with modificationItems: " + items, (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error("LDIF file does not exist.");
        }
        catch (Exception ioe) {
            log.error("Failed to import LDIF into backing store.", (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error("failed to close stream", (Throwable)e);
                }
            }
        }
        return this.count;
    }

    private Name getRelativeName(DirContext ctx, String baseDn) throws NamingException {
        CompoundName searchBaseDn;
        Properties props = new Properties();
        props.setProperty("jndi.syntax.direction", "right_to_left");
        props.setProperty("jndi.syntax.separator", ",");
        props.setProperty("jndi.syntax.ignorecase", "true");
        props.setProperty("jndi.syntax.trimblanks", "true");
        try {
            CompoundName ctxRoot = new CompoundName(ctx.getNameInNamespace(), props);
            searchBaseDn = new CompoundName(baseDn, props);
            if (!searchBaseDn.startsWith(ctxRoot)) {
                throw new NamingException("Invalid search base " + baseDn);
            }
            for (int ii = 0; ii < ctxRoot.size(); ++ii) {
                searchBaseDn.remove(0);
            }
        }
        catch (NamingException e) {
            throw new NamingException("Failed to initialize search base " + baseDn);
        }
        return searchBaseDn;
    }

    private InputStream getLdifStream() throws FileNotFoundException {
        if (!this.ldif.exists()) {
            InputStream in;
            if (this.loader != null && (in = this.loader.getResourceAsStream(this.ldif.getName())) != null) {
                return in;
            }
            in = this.getClass().getResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            in = ClassLoader.getSystemResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException("LDIF file does not exist.");
        }
        FileInputStream in = new FileInputStream(this.ldif);
        return in;
    }
}

