/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class StratumType
implements Comparable {
    public static final StratumType UNSPECIFIED = new StratumType(0, "Unspecified or unavailable.");
    public static final StratumType PRIMARY_REFERENCE = new StratumType(1, "Primary reference.");
    public static final StratumType SECONDARY_REFERENCE = new StratumType(2, "Secondary reference.");
    private static final StratumType[] values = new StratumType[]{UNSPECIFIED, PRIMARY_REFERENCE, SECONDARY_REFERENCE};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private StratumType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static StratumType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (StratumType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return UNSPECIFIED;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((StratumType)that).ordinal;
    }

    public String toString() {
        return this.name;
    }
}

