/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.directory.api.ldap.extras.extended.startTls.StartTlsResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTlsHandler
implements ExtendedOperationHandler<ExtendedRequest, ExtendedResponse> {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20037";
    private static final Set<String> EXTENSION_OIDS;
    private static final Logger LOG;
    private SSLContext sslContext;
    private List<String> cipherSuite;
    private List<String> enabledProtocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;

    @Override
    public void handleExtendedOperation(LdapSession session, ExtendedRequest req) throws Exception {
        LOG.info("Handling StartTLS request.");
        IoFilterChain chain = session.getIoSession().getFilterChain();
        SslFilter sslFilter = (SslFilter)chain.get("sslFilter");
        if (sslFilter == null) {
            sslFilter = new SslFilter(this.sslContext, false);
            if (this.cipherSuite != null && !this.cipherSuite.isEmpty()) {
                sslFilter.setEnabledCipherSuites(this.cipherSuite.toArray(new String[this.cipherSuite.size()]));
            }
            if (this.enabledProtocols != null && !this.enabledProtocols.isEmpty()) {
                sslFilter.setEnabledProtocols(this.enabledProtocols.toArray(new String[this.enabledProtocols.size()]));
            } else {
                sslFilter.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
            sslFilter.setNeedClientAuth(this.needClientAuth);
            sslFilter.setWantClientAuth(this.wantClientAuth);
            chain.addFirst("sslFilter", (IoFilter)sslFilter);
        } else {
            sslFilter.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            sslFilter.startSsl(session.getIoSession());
        }
        StartTlsResponseImpl res = new StartTlsResponseImpl(req.getMessageId());
        LdapResult result = res.getLdapResult();
        result.setResultCode(ResultCodeEnum.SUCCESS);
        res.setResponseName(EXTENSION_OID);
        session.getIoSession().setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE);
        session.getIoSession().write((Object)res);
    }

    @Override
    public final Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public final String getOid() {
        return EXTENSION_OID;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
        Transport[] transports;
        LOG.debug("Setting LDAP Service");
        Provider provider = Security.getProvider("SUN");
        LOG.debug("provider = {}", (Object)provider);
        try {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err((I18n)I18n.ERR_681, (Object[])new Object[0]), e);
        }
        try {
            this.sslContext.init(ldapServer.getKeyManagerFactory().getKeyManagers(), ldapServer.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err((I18n)I18n.ERR_682, (Object[])new Object[0]), e);
        }
        for (Transport transport : transports = ldapServer.getTransports()) {
            if (!(transport instanceof TcpTransport)) continue;
            TcpTransport tcpTransport = (TcpTransport)transport;
            this.cipherSuite = tcpTransport.getCipherSuite();
            this.enabledProtocols = tcpTransport.getEnabledProtocols();
            this.needClientAuth = tcpTransport.isNeedClientAuth();
            this.wantClientAuth = tcpTransport.isWantClientAuth();
            break;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StartTlsHandler.class);
        HashSet<String> set = new HashSet<String>(3);
        set.add(EXTENSION_OID);
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

