/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.replication.SyncreplConfiguration;
import org.apache.directory.shared.ldap.codec.ControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue.SyncDoneValueControlCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.message.InternalSearchResponseDone;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultDoneResponseHandler<T extends InternalSearchResponseDone> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResultDoneResponseHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public final void handle(LdapSession session, T response) throws Exception {
        block2: {
            LOG.debug("Handling single searchResultDone response: {}", response);
            SearchResultDoneCodec searchResult = (SearchResultDoneCodec)response;
            ControlCodec control = searchResult.getCurrentControl();
            SyncDoneValueControlCodec syncDoneCtrl = (SyncDoneValueControlCodec)control.getControlValue();
            if (syncDoneCtrl.getCookie() != null) {
                byte[] syncCookie = syncDoneCtrl.getCookie();
                LOG.debug("assigning cookie from sync done value control: {}", (Object)StringTools.utf8ToString((byte[])syncCookie));
            } else {
                LOG.info("cookie in syncdone message is null");
            }
            SyncreplConfiguration config = (SyncreplConfiguration)session.getIoSession().getAttribute((Object)"SYNC_COOKIE");
            if (config.isRefreshPersist()) break block2;
            config.setRefreshPersist(true);
            LOG.debug("Swithing to RefreshAndPersist");
        }
    }
}

