/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.cursor.ClosureMonitor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.PersistentSearchListener;
import org.apache.directory.server.ldap.handlers.ReferralAwareRequestHandler;
import org.apache.directory.server.ldap.handlers.SearchAbandonListener;
import org.apache.directory.server.ldap.handlers.SearchTimeLimitingMonitor;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.PersistentSearchControl;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.Response;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchResponseDone;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.SearchResponseReferenceImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHandler
extends ReferralAwareRequestHandler<SearchRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private AttributeType objectClassAttributeType;

    private EqualityNode<String> newIsReferralEqualityNode(LdapSession session) throws Exception {
        if (this.objectClassAttributeType == null) {
            this.objectClassAttributeType = session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().lookup("objectClass");
        }
        EqualityNode ocIsReferral = new EqualityNode("objectClass", (Value)new ServerStringValue(this.objectClassAttributeType, "referral"));
        return ocIsReferral;
    }

    private void handlePersistentSearch(LdapSession session, SearchRequest req, PersistentSearchControl psearchControl) throws Exception {
        SearchResponseDone done;
        if (!psearchControl.isChangesOnly() && (done = this.doSimpleSearch(session, req)).getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            session.getIoSession().write((Object)done);
            return;
        }
        if (req.isAbandoned()) {
            return;
        }
        PersistentSearchListener handler = new PersistentSearchListener(session, req);
        NotificationCriteria criteria = new NotificationCriteria();
        criteria.setAliasDerefMode(req.getDerefAliases());
        criteria.setBase(req.getBase());
        criteria.setFilter(req.getFilter());
        criteria.setScope(req.getScope());
        criteria.setEventMask(EventType.getEventTypes((int)psearchControl.getChangeTypes()));
        this.getLdapServer().getDirectoryService().getEventService().addListener((DirectoryListener)handler, criteria);
        req.addAbandonListener((AbandonListener)new SearchAbandonListener(this.ldapService, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRootDseSearch(LdapSession session, SearchRequest req) throws Exception {
        EntryFilteringCursor cursor = null;
        try {
            cursor = session.getCoreSession().search(req);
            cursor.beforeFirst();
            boolean hasRootDSE = false;
            while (cursor.next()) {
                if (hasRootDSE) {
                    LOG.error("Got back more than one entry for search on RootDSE which means Cursor is not functioning properly!");
                    continue;
                }
                hasRootDSE = true;
                ClonedServerEntry entry = (ClonedServerEntry)cursor.get();
                session.getIoSession().write((Object)this.generateResponse(session, req, entry));
            }
            session.getIoSession().write((Object)req.getResultResponse());
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (NamingException e) {
                    LOG.error("failed on list.close()", (Throwable)e);
                }
            }
        }
    }

    private void setTimeLimitsOnCursor(SearchRequest req, LdapSession session, EntryFilteringCursor cursor) {
        if (session.getCoreSession().isAnAdministrator() && req.getTimeLimit() == 0) {
            return;
        }
        if (this.ldapService.getMaxTimeLimit() == 0 && req.getTimeLimit() == 0) {
            return;
        }
        if (req.getTimeLimit() == 0) {
            cursor.setClosureMonitor((ClosureMonitor)new SearchTimeLimitingMonitor(this.ldapService.getMaxTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        if (this.ldapService.getMaxTimeLimit() >= req.getTimeLimit()) {
            cursor.setClosureMonitor((ClosureMonitor)new SearchTimeLimitingMonitor(req.getTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        cursor.setClosureMonitor((ClosureMonitor)new SearchTimeLimitingMonitor(this.ldapService.getMaxTimeLimit(), TimeUnit.SECONDS));
    }

    private int getSearchSizeLimits(SearchRequest req, LdapSession session) {
        LOG.debug("req size limit = {}, configured size limit = {}", (Object)req.getSizeLimit(), (Object)this.ldapService.getMaxSizeLimit());
        if (session.getCoreSession().isAnAdministrator() && req.getSizeLimit() == 0) {
            return 0;
        }
        if (session.getCoreSession().isAnAdministrator()) {
            return req.getSizeLimit();
        }
        if (this.ldapService.getMaxSizeLimit() == 0 && req.getSizeLimit() == 0) {
            return 0;
        }
        if (req.getSizeLimit() == 0) {
            return this.ldapService.getMaxSizeLimit();
        }
        if (this.ldapService.getMaxSizeLimit() == 0) {
            return req.getSizeLimit();
        }
        if (this.ldapService.getMaxSizeLimit() >= req.getSizeLimit()) {
            return req.getSizeLimit();
        }
        return this.ldapService.getMaxSizeLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResponseDone doSimpleSearch(LdapSession session, SearchRequest req) throws Exception {
        EntryFilteringCursor cursor = null;
        try {
            LdapResult ldapResult = req.getResultResponse().getLdapResult();
            cursor = session.getCoreSession().search(req);
            req.addAbandonListener((AbandonListener)new SearchAbandonListener(this.ldapService, cursor));
            this.setTimeLimitsOnCursor(req, session, cursor);
            int sizeLimit = this.getSearchSizeLimits(req, session);
            LOG.debug("using {} for size limit", (Object)sizeLimit);
            cursor.beforeFirst();
            if (sizeLimit == 0) {
                while (cursor.next() && !session.getIoSession().isClosing()) {
                    ClonedServerEntry entry = (ClonedServerEntry)cursor.get();
                    session.getIoSession().write((Object)this.generateResponse(session, req, entry));
                }
            } else {
                int count = 0;
                while (cursor.next() && !session.getIoSession().isClosing()) {
                    ClonedServerEntry entry;
                    if (count < sizeLimit) {
                        entry = (ClonedServerEntry)cursor.get();
                        session.getIoSession().write((Object)this.generateResponse(session, req, entry));
                        ++count;
                        continue;
                    }
                    ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
                    entry = (SearchResponseDone)req.getResultResponse();
                    return entry;
                }
            }
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
            SearchResponseDone searchResponseDone = (SearchResponseDone)req.getResultResponse();
            return searchResponseDone;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (NamingException e) {
                    LOG.error("failed on list.close()", (Throwable)e);
                }
            }
        }
    }

    private Response generateResponse(LdapSession session, SearchRequest req, ClonedServerEntry entry) throws Exception {
        EntryAttribute ref = entry.getOriginalEntry().get("ref");
        boolean hasManageDsaItControl = req.getControls().containsKey("2.16.840.1.113730.3.4.2");
        if (ref != null && !hasManageDsaItControl) {
            SearchResponseReferenceImpl respRef = new SearchResponseReferenceImpl(req.getMessageId());
            respRef.setReferral((Referral)new ReferralImpl());
            for (Value val : ref) {
                String url = (String)val.get();
                if (!url.startsWith("ldap")) {
                    respRef.getReferral().addLdapUrl(url);
                }
                LdapURL ldapUrl = new LdapURL();
                ldapUrl.setForceScopeRendering(true);
                try {
                    ldapUrl.parse(url.toCharArray());
                }
                catch (LdapURLEncodingException e) {
                    LOG.error("Bad URL ({}) for ref in {}.  Reference will be ignored.", (Object)url, (Object)entry);
                }
                switch (req.getScope()) {
                    case SUBTREE: {
                        ldapUrl.setScope(SearchScope.SUBTREE.getJndiScope());
                        break;
                    }
                    case ONELEVEL: {
                        ldapUrl.setScope(SearchScope.OBJECT.getJndiScope());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected base scope.");
                    }
                }
                respRef.getReferral().addLdapUrl(ldapUrl.toString());
            }
            return respRef;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(req.getMessageId());
        respEntry.setEntry((Entry)entry);
        respEntry.setObjectName(entry.getDn());
        return respEntry;
    }

    public void modifyFilter(LdapSession session, SearchRequest req) throws Exception {
        if (req.hasControl("2.16.840.1.113730.3.4.2")) {
            return;
        }
        if (SearchHandler.isSubSchemaSubEntrySearch(session, req)) {
            return;
        }
        if (req.getFilter() instanceof PresenceNode) {
            PresenceNode presenceNode = (PresenceNode)req.getFilter();
            AttributeType at = session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().lookup(presenceNode.getAttribute());
            if (at.getOid().equals("2.5.4.0")) {
                return;
            }
        }
        req.setFilter((ExprNode)new OrNode(new ExprNode[]{req.getFilter(), this.newIsReferralEqualityNode(session)}));
    }

    @Override
    public void handleIgnoringReferrals(LdapSession session, LdapDN reqTargetDn, ClonedServerEntry entry, SearchRequest req) {
        if (IS_DEBUG) {
            LOG.debug("Message received:  {}", (Object)req.toString());
        }
        session.registerOutstandingRequest((AbandonableRequest)req);
        try {
            this.modifyFilter(session, req);
            if (SearchHandler.isRootDSESearch(req)) {
                this.handleRootDseSearch(session, req);
                return;
            }
            PersistentSearchControl psearchControl = (PersistentSearchControl)req.getControls().get("2.16.840.1.113730.3.4.3");
            if (psearchControl != null) {
                this.handlePersistentSearch(session, req, psearchControl);
                return;
            }
            SearchResponseDone done = this.doSimpleSearch(session, req);
            session.getIoSession().write((Object)done);
            session.unregisterOutstandingRequest((AbandonableRequest)req);
        }
        catch (Exception e) {
            if (e instanceof OperationAbandonedException) {
                return;
            }
            this.handleException(session, req, e);
        }
    }

    private static boolean isRootDSESearch(SearchRequest req) {
        boolean isBaseIsRoot = req.getBase().isEmpty();
        boolean isBaseScope = req.getScope() == SearchScope.OBJECT;
        boolean isRootDSEFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            String attribute = ((PresenceNode)req.getFilter()).getAttribute();
            isRootDSEFilter = attribute.equalsIgnoreCase("objectClass") || attribute.equals("2.5.4.0");
        }
        return isBaseIsRoot && isBaseScope && isRootDSEFilter;
    }

    private static boolean isSubSchemaSubEntrySearch(LdapSession session, SearchRequest req) throws Exception {
        LdapDN base = req.getBase();
        String baseNormForm = base.isNormalized() ? base.getNormName() : base.toNormName();
        DirectoryService ds = session.getCoreSession().getDirectoryService();
        PartitionNexus nexus = ds.getPartitionNexus();
        Value subschemaSubentry = nexus.getRootDSE(null).get("subschemaSubentry").get();
        LdapDN subschemaSubentryDn = new LdapDN((String)subschemaSubentry.get());
        subschemaSubentryDn.normalize(ds.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        String subschemaSubentryDnNorm = subschemaSubentryDn.getNormName();
        return subschemaSubentryDnNorm.equals(baseNormForm);
    }
}

