/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapService;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.message.AbandonRequest;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ResultResponseRequest;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LdapRequestHandler<T extends Request>
implements MessageHandler<T> {
    protected LdapService ldapService;

    public final LdapService getLdapServer() {
        return this.ldapService;
    }

    public final void setLdapServer(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    public final boolean isConfidentialityRequirementSatisfied(IoSession session) {
        if (!this.ldapService.isConfidentialityRequired()) {
            return true;
        }
        IoFilterChain chain = session.getFilterChain();
        return chain.contains("sslFilter");
    }

    public void rejectWithoutConfidentiality(IoSession session, ResultResponse resp) {
        LdapResult result = resp.getLdapResult();
        result.setResultCode(ResultCodeEnum.CONFIDENTIALITY_REQUIRED);
        result.setErrorMessage("Confidentiality (TLS secured connection) is required.");
        session.write((Object)resp);
    }

    public final void messageReceived(IoSession session, T message) throws Exception {
        LdapSession ldapSession = this.ldapService.getLdapSessionManager().getLdapSession(session);
        ldapSession.setLdapServer(this.ldapService);
        if (!this.isConfidentialityRequirementSatisfied(session)) {
            if (message instanceof ExtendedRequest) {
                ExtendedRequest req = (ExtendedRequest)message;
                if (!req.getID().equals("1.3.6.1.4.1.1466.20037")) {
                    this.rejectWithoutConfidentiality(session, req.getResultResponse());
                    return;
                }
            } else {
                if (message instanceof ResultResponseRequest) {
                    this.rejectWithoutConfidentiality(session, ((ResultResponseRequest)message).getResultResponse());
                    return;
                }
                return;
            }
        }
        if (!(message instanceof BindRequest)) {
            CoreSession coreSession = null;
            if (ldapSession.isAuthenticated()) {
                coreSession = ldapSession.getCoreSession();
                this.handle(ldapSession, message);
                return;
            }
            coreSession = this.getLdapServer().getDirectoryService().getSession();
            ldapSession.setCoreSession(coreSession);
            if (message instanceof AbandonRequest) {
                return;
            }
            this.handle(ldapSession, message);
            return;
        }
        this.handle(ldapSession, message);
    }

    public abstract void handle(LdapSession var1, T var2) throws Exception;
}

