/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.gui.OutstandingRequestsDialog;
import org.apache.directory.server.ldap.gui.SessionsModel;
import org.apache.directory.server.ldap.gui.ShutdownDialog;
import org.apache.directory.server.ldap.gui.ShutdownProgress;
import org.apache.directory.server.ldap.handlers.extended.GracefulShutdownHandler;
import org.apache.directory.shared.ldap.message.extended.GracefulDisconnect;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionsFrame
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(SessionsFrame.class);
    private static final long serialVersionUID = -863445561454536133L;
    private static final String REFRESH_COMMAND = "Refresh";
    boolean isServiceBound = true;
    private IoSession requestor;
    private IoHandler ldapProvider;
    private JPanel jContentPane;
    private JPanel mainPanel;
    private JScrollPane sessionsPane;
    private JTable sessionsTable;
    private JPanel filterPanel;
    private JButton filterButton;
    private JTextField filterText;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenuItem exitItem;
    private JMenu menuSession;
    private JMenuItem closeItem;
    private JMenu menuSendNoD;
    private JMenuItem unavailableItem;
    private JMenuItem protocolErrorItem;
    private JMenuItem strongAuthRequiredItem;
    private JPanel southPanel;
    private JMenuItem showRequests;
    private JButton refreshButton;
    private IoSession selected;
    private JMenuItem unbindItem;
    private JMenuItem bindItem;
    private SessionRegistry registry;

    public SessionsFrame(SessionRegistry registry) {
        this.registry = registry;
        this.initialize();
    }

    private void initialize() {
        this.setSize(789, 436);
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("Sessions");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SessionsFrame.this.setVisible(false);
                SessionsFrame.this.dispose();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getFilterPanel(), "North");
            this.mainPanel.add((Component)this.getSessionsPane(), "Center");
            this.mainPanel.add((Component)this.getSouthPanel(), "South");
        }
        return this.mainPanel;
    }

    private JScrollPane getSessionsPane() {
        if (this.sessionsPane == null) {
            this.sessionsPane = new JScrollPane();
            this.sessionsPane.setName("jScrollPane");
            this.sessionsPane.setViewportView(this.getSessionsTable());
        }
        return this.sessionsPane;
    }

    private JTable getSessionsTable() {
        if (this.sessionsTable == null) {
            this.sessionsTable = new JTable();
            this.sessionsTable.setSelectionMode(0);
            this.sessionsTable.setModel(new SessionsModel(this.registry.getSessions()));
            this.sessionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int row = SessionsFrame.this.sessionsTable.getSelectedRow();
                    if (row == -1) {
                        SessionsFrame.this.selected = null;
                    } else {
                        SessionsFrame.this.selected = ((SessionsModel)SessionsFrame.this.sessionsTable.getModel()).getIoSession(row);
                        SessionsFrame.this.closeItem.setEnabled(true);
                        SessionsFrame.this.menuSendNoD.setEnabled(true);
                        SessionsFrame.this.showRequests.setEnabled(true);
                    }
                }
            });
        }
        return this.sessionsTable;
    }

    private JPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = new JPanel();
            this.filterPanel.setLayout(new BoxLayout(this.getFilterPanel(), 0));
            this.filterPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.filterPanel.add((Component)this.getFilterButton(), null);
            this.filterPanel.add((Component)this.getFilterText(), null);
        }
        return this.filterPanel;
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setText("Filter");
        }
        return this.filterButton;
    }

    private JTextField getFilterText() {
        if (this.filterText == null) {
            this.filterText = new JTextField();
        }
        return this.filterText;
    }

    private JMenuBar getMainMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.getMenuFile());
            this.menuBar.add(this.getMenuSession());
        }
        return this.menuBar;
    }

    private JMenu getMenuFile() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu();
            this.menuFile.setText("File");
            this.menuFile.add(this.getExitItem());
        }
        return this.menuFile;
    }

    private JMenuItem getExitItem() {
        if (this.exitItem == null) {
            this.exitItem = new JMenuItem();
            this.exitItem.setText("exit");
            this.exitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SessionsFrame.this.setVisible(false);
                    SessionsFrame.this.dispose();
                }
            });
        }
        return this.exitItem;
    }

    private JMenu getMenuSession() {
        if (this.menuSession == null) {
            this.menuSession = new JMenu();
            this.menuSession.setText("Session");
            this.menuSession.add(this.getCloseItem());
            this.closeItem.setEnabled(false);
            this.menuSession.add(this.getMenuSendNoD());
            this.menuSendNoD.setEnabled(false);
            this.menuSession.add(this.getShowRequests());
            this.menuSession.add(this.getUnbindItem());
            this.menuSession.add(this.getBindItem());
            this.showRequests.setEnabled(false);
        }
        return this.menuSession;
    }

    private JMenuItem getCloseItem() {
        if (this.closeItem == null) {
            this.closeItem = new JMenuItem();
            this.closeItem.setText("close");
            this.closeItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SessionsFrame.this.registry.terminateSession(SessionsFrame.this.selected);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e1) {
                        LOG.error("", (Throwable)e1);
                    }
                    SessionsFrame.this.refresh();
                }
            });
        }
        return this.closeItem;
    }

    private JMenu getMenuSendNoD() {
        if (this.menuSendNoD == null) {
            this.menuSendNoD = new JMenu();
            this.menuSendNoD.setText("Send NoD");
            this.menuSendNoD.add(this.getUnavailableItem());
            this.menuSendNoD.add(this.getProtocolErrorItem());
            this.menuSendNoD.add(this.getStrongAuthRequiredItem());
        }
        return this.menuSendNoD;
    }

    private JMenuItem getUnavailableItem() {
        if (this.unavailableItem == null) {
            this.unavailableItem = new JMenuItem();
            this.unavailableItem.setText("unavailable");
            this.unavailableItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SessionsFrame.this.selected.write((Object)NoticeOfDisconnect.UNAVAILABLE);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e1) {
                        LOG.error("", (Throwable)e1);
                    }
                    SessionsFrame.this.refresh();
                }
            });
        }
        return this.unavailableItem;
    }

    private JMenuItem getProtocolErrorItem() {
        if (this.protocolErrorItem == null) {
            this.protocolErrorItem = new JMenuItem();
            this.protocolErrorItem.setText("protocolError");
            this.protocolErrorItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SessionsFrame.this.selected.write((Object)NoticeOfDisconnect.PROTOCOLERROR);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e1) {
                        LOG.error("", (Throwable)e1);
                    }
                    SessionsFrame.this.refresh();
                }
            });
        }
        return this.protocolErrorItem;
    }

    private JMenuItem getStrongAuthRequiredItem() {
        if (this.strongAuthRequiredItem == null) {
            this.strongAuthRequiredItem = new JMenuItem();
            this.strongAuthRequiredItem.setText("strongAuthRequired");
            this.strongAuthRequiredItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WriteFuture future = SessionsFrame.this.selected.write((Object)NoticeOfDisconnect.STRONGAUTHREQUIRED);
                    try {
                        future.join(1000L);
                        CloseFuture cfuture = SessionsFrame.this.selected.close();
                        cfuture.join(1000L);
                    }
                    catch (Exception e1) {
                        LOG.error("", (Throwable)e1);
                    }
                    SessionsFrame.this.refresh();
                }
            });
        }
        return this.strongAuthRequiredItem;
    }

    private JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = new JPanel();
            this.southPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.southPanel.add((Component)this.getRefreshButton(), null);
        }
        return this.southPanel;
    }

    private JMenuItem getShowRequests() {
        if (this.showRequests == null) {
            this.showRequests = new JMenuItem();
            this.showRequests.setText("show requests");
            this.showRequests.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OutstandingRequestsDialog dialog = new OutstandingRequestsDialog(SessionsFrame.this, SessionsFrame.this.selected, SessionsFrame.this.registry);
                    dialog.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent e) {
                            e.getWindow().dispose();
                        }
                    });
                    dialog.setVisible(true);
                }
            });
        }
        return this.showRequests;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setText(REFRESH_COMMAND);
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(SessionsFrame.REFRESH_COMMAND)) {
                        SessionsFrame.this.refresh();
                    }
                }
            });
        }
        return this.refreshButton;
    }

    private void refresh() {
        LOG.info("Refreshing Sessions UI");
        this.sessionsTable.setModel(new SessionsModel(this.registry.getSessions()));
        this.closeItem.setEnabled(false);
        this.menuSendNoD.setEnabled(false);
        this.showRequests.setEnabled(false);
        this.unbindItem.setEnabled(this.isServiceBound);
        this.bindItem.setEnabled(!this.isServiceBound);
    }

    public void setRequestor(IoSession requestor) {
        this.requestor = requestor;
    }

    private JMenuItem getUnbindItem() {
        if (this.unbindItem == null) {
            this.unbindItem = new JMenuItem();
            this.unbindItem.setText("Unbind Service");
            this.unbindItem.setEnabled(this.isServiceBound);
            this.unbindItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int input = JOptionPane.showConfirmDialog(SessionsFrame.this, "Selecting no will send a notice of disconnect ONLY.  \nSelecting yes will send both.  Cancel will abort unbind.", "Send graceful disconnect before disconnect notice?", 1);
                    IoAcceptor acceptor = (IoAcceptor)SessionsFrame.this.requestor.getService();
                    ArrayList<IoSession> sessions = new ArrayList<IoSession>(acceptor.getManagedSessions(SessionsFrame.this.requestor.getServiceAddress()));
                    if (input != 2) {
                        if (input == 1) {
                            GracefulShutdownHandler.sendNoticeOfDisconnect(sessions, SessionsFrame.this.requestor);
                            acceptor.unbind(SessionsFrame.this.requestor.getServiceAddress());
                            SessionsFrame.this.isServiceBound = false;
                            SessionsFrame.this.unbindItem.setEnabled(SessionsFrame.this.isServiceBound);
                            SessionsFrame.this.bindItem.setEnabled(!SessionsFrame.this.isServiceBound);
                            JOptionPane.showMessageDialog(SessionsFrame.this, "Ldap service for " + SessionsFrame.this.requestor.getLocalAddress() + " has been successfully unbound.", "Success!", 1);
                            SessionsFrame.this.refresh();
                        } else {
                            ShutdownDialog dialog = new ShutdownDialog();
                            SessionsFrame.this.setCenteredPosition(SessionsFrame.this, dialog);
                            dialog.setModal(true);
                            dialog.setVisible(true);
                            if (dialog.isSendCanceled()) {
                                LOG.debug("GracefulShutdown was canceled.");
                                JOptionPane.showMessageDialog(SessionsFrame.this, "Shutdown has been canceled.", "Graceful Shutdown Aborted", 0);
                                return;
                            }
                            LOG.debug("GracefulShutdown parameters captured.");
                            int timeOffline = dialog.getTimeOffline();
                            int delay = dialog.getDelay();
                            GracefulDisconnect graceful = new GracefulDisconnect(timeOffline, delay);
                            GracefulShutdownHandler.sendGracefulDisconnect(sessions, graceful, SessionsFrame.this.requestor);
                            acceptor.unbind(SessionsFrame.this.requestor.getServiceAddress());
                            SessionsFrame.this.isServiceBound = false;
                            SessionsFrame.this.unbindItem.setEnabled(SessionsFrame.this.isServiceBound);
                            SessionsFrame.this.bindItem.setEnabled(!SessionsFrame.this.isServiceBound);
                            if (delay > 0) {
                                ShutdownProgress progress = new ShutdownProgress();
                                SessionsFrame.this.setCenteredPosition(SessionsFrame.this, progress);
                                progress.setModal(true);
                                progress.setTime(delay * 1000);
                                Thread t = new Thread(progress);
                                t.start();
                                progress.setVisible(true);
                            }
                            GracefulShutdownHandler.sendNoticeOfDisconnect(sessions, SessionsFrame.this.requestor);
                            JOptionPane.showMessageDialog(SessionsFrame.this, "Ldap service for " + SessionsFrame.this.requestor.getLocalAddress() + " has been successfully unbound.", "Success!", 0);
                            SessionsFrame.this.refresh();
                        }
                    }
                }
            });
        }
        return this.unbindItem;
    }

    private void setCenteredPosition(JFrame frame, Component comp) {
        Point pt = new Point();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        pt.x = (screenSize.width - frame.getWidth()) / 2;
        pt.y = (screenSize.height - frame.getHeight()) / 2;
        pt.x += (frame.getWidth() - comp.getWidth()) / 2;
        pt.y += (frame.getHeight() - comp.getHeight()) / 2;
        comp.setLocation(pt);
    }

    private JMenuItem getBindItem() {
        if (this.bindItem == null) {
            this.bindItem = new JMenuItem();
            this.bindItem.setText("Bind Service");
            this.unbindItem.setEnabled(!this.isServiceBound);
            this.bindItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ((IoAcceptor)SessionsFrame.this.requestor.getService()).bind(SessionsFrame.this.requestor.getServiceAddress(), SessionsFrame.this.getLdapProvider());
                        JOptionPane.showMessageDialog(SessionsFrame.this, "Ldap service " + SessionsFrame.this.requestor.getServiceAddress() + " has been successfully bound.\n" + " Clients may now connect to the server once again.", "Success!", 1);
                        SessionsFrame.this.isServiceBound = true;
                        SessionsFrame.this.unbindItem.setEnabled(SessionsFrame.this.isServiceBound);
                        SessionsFrame.this.bindItem.setEnabled(!SessionsFrame.this.isServiceBound);
                    }
                    catch (IOException e1) {
                        LOG.error("failed to rebind ldap service", (Throwable)e1);
                        JOptionPane.showMessageDialog(SessionsFrame.this, e1.getMessage(), "Error encountered!", 0);
                    }
                }
            });
        }
        return this.bindItem;
    }

    public void setLdapProvider(IoHandler ldapProvider) {
        this.ldapProvider = ldapProvider;
    }

    public IoHandler getLdapProvider() {
        return this.ldapProvider;
    }
}

