/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.extended;

import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.server.core.security.CoreKeyStoreSpi;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTlsHandler
implements ExtendedOperationHandler {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20037";
    private static final Set<String> EXTENSION_OIDS;
    private static final Logger LOG;
    private SSLContext sslContext;

    @Override
    public void handleExtendedOperation(IoSession session, SessionRegistry registry, ExtendedRequest req) throws Exception {
        LOG.info("Handling StartTLS request.");
        IoFilterChain chain = session.getFilterChain();
        SSLFilter sslFilter = (SSLFilter)chain.get("sslFilter");
        if (sslFilter == null) {
            sslFilter = new SSLFilter(this.sslContext);
            chain.addFirst("sslFilter", (IoFilter)sslFilter);
        } else {
            sslFilter.startSSL(session);
        }
        ExtendedResponseImpl res = new ExtendedResponseImpl(req.getMessageId());
        LdapResult result = res.getLdapResult();
        result.setResultCode(ResultCodeEnum.SUCCESS);
        res.setResponseName(EXTENSION_OID);
        res.setResponse(new byte[0]);
        session.setAttribute(SSLFilter.DISABLE_ENCRYPTION_ONCE);
        session.write((Object)res);
    }

    @Override
    public final Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public final String getOid() {
        return EXTENSION_OID;
    }

    @Override
    public void setLdapProvider(LdapServer ldapServer) {
        LOG.debug("Setting LDAP Service");
        Provider provider = Security.getProvider("SUN");
        LOG.debug("provider = {}", (Object)provider);
        CoreKeyStoreSpi coreKeyStoreSpi = new CoreKeyStoreSpi(ldapServer.getDirectoryService());
        KeyStore keyStore = new KeyStore((KeyStoreSpi)coreKeyStoreSpi, provider, "JKS"){};
        try {
            keyStore.load(null, null);
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed on keystore load which should never really happen.");
        }
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create KeyManagerFactory", e);
        }
        try {
            keyManagerFactory.init(keyStore, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize KeyManagerFactory", e);
        }
        try {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SSLContext", e);
        }
        try {
            this.sslContext.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{new ServerX509TrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SSLContext", e);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StartTlsHandler.class);
        HashSet<String> set = new HashSet<String>(3);
        set.add(EXTENSION_OID);
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }

    class ServerX509TrustManager
    implements X509TrustManager {
        ServerX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            LOG.debug("checkClientTrusted() called");
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            LOG.debug("checkServerTrusted() called");
        }

        public X509Certificate[] getAcceptedIssuers() {
            LOG.debug("getAcceptedIssuers() called");
            return new X509Certificate[0];
        }
    }
}

