/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.extended;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.swing.JFrame;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionFrame;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolProvider;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.gui.SessionsFrame;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.extended.LaunchDiagnosticUiResponse;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.mina.common.IoSession;

public class LaunchDiagnosticUiHandler
implements ExtendedOperationHandler {
    public static final Set EXTENSION_OIDS;
    private LdapProtocolProvider ldapProvider;

    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.1";
    }

    public void handleExtendedOperation(IoSession requestor, SessionRegistry registry, ExtendedRequest req) throws NamingException {
        LdapContext ctx = registry.getLdapContext(requestor, null, false);
        if ((ctx = (LdapContext)ctx.lookup("")) instanceof ServerLdapContext) {
            ServerLdapContext slc = (ServerLdapContext)ctx;
            DirectoryService service = slc.getService();
            if (!slc.getPrincipal().getName().equalsIgnoreCase("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
                requestor.write((Object)new LaunchDiagnosticUiResponse(req.getMessageId(), ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS));
                return;
            }
            requestor.write((Object)new LaunchDiagnosticUiResponse(req.getMessageId()));
            PartitionNexus nexus = service.getConfiguration().getPartitionNexus();
            Iterator list = nexus.listSuffixes(new ListSuffixOperationContext());
            int launchedWindowCount = 0;
            while (list.hasNext()) {
                LdapDN dn = new LdapDN((String)list.next());
                Partition partition = nexus.getPartition(dn);
                if (!(partition instanceof BTreePartition)) continue;
                BTreePartition btPartition = (BTreePartition)partition;
                PartitionFrame frame = new PartitionFrame(btPartition, btPartition.getSearchEngine());
                Point pos = this.getCenteredPosition((JFrame)frame);
                pos.y = launchedWindowCount * 20 + pos.y;
                double multiplier = this.getAspectRatio() * 20.0;
                pos.x = (int)((double)launchedWindowCount * multiplier) + pos.x;
                frame.setLocation(pos);
                frame.setVisible(true);
                ++launchedWindowCount;
            }
            SessionsFrame sessions = new SessionsFrame();
            sessions.setRequestor(requestor);
            sessions.setLdapProvider(this.ldapProvider.getHandler());
            Point pos = this.getCenteredPosition(sessions);
            pos.y = launchedWindowCount * 20 + pos.y;
            double multiplier = this.getAspectRatio() * 20.0;
            pos.x = (int)((double)launchedWindowCount * multiplier) + pos.x;
            sessions.setLocation(pos);
            sessions.setVisible(true);
            return;
        }
        requestor.write((Object)new LaunchDiagnosticUiResponse(req.getMessageId(), ResultCodeEnum.OPERATIONS_ERROR));
    }

    public double getAspectRatio() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        return screenSize.getWidth() / screenSize.getHeight();
    }

    public Point getCenteredPosition(JFrame frame) {
        Point pt = new Point();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        pt.x = (screenSize.width - frame.getWidth()) / 2;
        pt.y = (screenSize.height - frame.getHeight()) / 2;
        return pt;
    }

    public Set getExtensionOids() {
        return EXTENSION_OIDS;
    }

    public void setLdapProvider(LdapProtocolProvider provider) {
        this.ldapProvider = provider;
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("1.3.6.1.4.1.18060.0.1.1");
        set.add("1.3.6.1.4.1.18060.0.1.2");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

