/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.support.bind.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.support.bind.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.support.bind.GssapiMechanismHandler;
import org.apache.directory.server.ldap.support.bind.MechanismHandler;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleSasl
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(HandleSasl.class);
    private static final Map DEFAULT_HANDLERS;

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        String sessionMechanism = (String)session.getAttribute("sessionMechanism");
        if (DEFAULT_HANDLERS.containsKey(sessionMechanism)) {
            SaslServer ss = this.handleMechanism(sessionMechanism, session, message);
            this.handleMechanism(ss, next, session, message);
        } else {
            next.execute(session, message);
        }
    }

    private SaslServer handleMechanism(String mechanism, IoSession session, Object message) throws Exception {
        MechanismHandler mechanismHandler = (MechanismHandler)DEFAULT_HANDLERS.get(mechanism);
        if (mechanismHandler == null) {
            throw new IllegalArgumentException("Handler unavailable for " + mechanism);
        }
        return mechanismHandler.handleMechanism(session, message);
    }

    private void handleMechanism(SaslServer ss, IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        BindRequest request = (BindRequest)message;
        LdapResult result = request.getResultResponse().getLdapResult();
        if (!ss.isComplete()) {
            try {
                if (request.getCredentials() == null) {
                    request.setCredentials(new byte[0]);
                }
                byte[] tokenBytes = ss.evaluateResponse(request.getCredentials());
                if (ss.isComplete()) {
                    session.setAttribute("saslCreds", (Object)tokenBytes);
                    next.execute(session, message);
                } else {
                    log.info("Continuation token had length " + tokenBytes.length);
                    result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                    BindResponse resp = (BindResponse)request.getResultResponse();
                    resp.setServerSaslCreds(tokenBytes);
                    session.write((Object)resp);
                    log.debug("Returning final authentication data to client to complete context.");
                }
            }
            catch (SaslException se) {
                log.error(se.getMessage());
                result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                result.setErrorMessage(se.getMessage());
                session.write((Object)request.getResultResponse());
            }
        }
    }

    static {
        HashMap<String, MechanismHandler> map = new HashMap<String, MechanismHandler>();
        map.put("CRAM-MD5", new CramMd5MechanismHandler());
        map.put("DIGEST-MD5", new DigestMd5MechanismHandler());
        map.put("GSSAPI", new GssapiMechanismHandler());
        DEFAULT_HANDLERS = Collections.unmodifiableMap(map);
    }
}

