/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.bind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapConfiguration;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureChain
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(ConfigureChain.class);
    private DirContext ctx;

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        LdapConfiguration config = (LdapConfiguration)((Object)session.getAttribute(LdapConfiguration.class.toString()));
        HashMap<String, String> saslProps = new HashMap<String, String>();
        saslProps.put("javax.security.sasl.qop", this.getActiveQop(config));
        saslProps.put("com.sun.security.sasl.digest.realm", this.getActiveRealms(config));
        session.setAttribute("saslProps", saslProps);
        session.setAttribute("saslHost", (Object)config.getSaslHost());
        session.setAttribute("baseDn", (Object)config.getSearchBaseDn());
        Set activeMechanisms = this.getActiveMechanisms(config);
        if (activeMechanisms.contains("GSSAPI")) {
            try {
                Subject saslSubject = this.getSubject(config);
                session.setAttribute("saslSubject", (Object)saslSubject);
            }
            catch (ServiceConfigurationException sce) {
                activeMechanisms.remove("GSSAPI");
                log.warn(sce.getMessage());
            }
        }
        session.setAttribute("supportedMechanisms", (Object)activeMechanisms);
        next.execute(session, message);
    }

    private Set getActiveMechanisms(LdapConfiguration config) {
        ArrayList<String> supportedMechanisms = new ArrayList<String>();
        supportedMechanisms.add("SIMPLE");
        supportedMechanisms.add("CRAM-MD5");
        supportedMechanisms.add("DIGEST-MD5");
        supportedMechanisms.add("GSSAPI");
        HashSet<String> activeMechanisms = new HashSet<String>();
        for (String desiredMechanism : config.getSupportedMechanisms()) {
            if (!supportedMechanisms.contains(desiredMechanism)) continue;
            activeMechanisms.add(desiredMechanism);
        }
        return activeMechanisms;
    }

    private String getActiveQop(LdapConfiguration config) {
        ArrayList<String> supportedQop = new ArrayList<String>();
        supportedQop.add("auth");
        supportedQop.add("auth-int");
        supportedQop.add("auth-conf");
        StringBuilder saslQop = new StringBuilder();
        Iterator it = config.getSaslQop().iterator();
        while (it.hasNext()) {
            String desiredQopLevel = (String)it.next();
            if (supportedQop.contains(desiredQopLevel)) {
                saslQop.append(desiredQopLevel);
            }
            if (!it.hasNext()) continue;
            saslQop.append(",");
        }
        return saslQop.toString();
    }

    private String getActiveRealms(LdapConfiguration config) {
        StringBuilder realms = new StringBuilder();
        Iterator it = config.getSaslRealms().iterator();
        while (it.hasNext()) {
            String realm = (String)it.next();
            realms.append(realm);
            if (!it.hasNext()) continue;
            realms.append(" ");
        }
        return realms.toString();
    }

    private Subject getSubject(LdapConfiguration config) throws ServiceConfigurationException {
        PrincipalStoreEntry entry;
        String servicePrincipalName = config.getSaslPrincipal();
        KerberosPrincipal servicePrincipal = new KerberosPrincipal(servicePrincipalName);
        GetPrincipal getPrincipal = new GetPrincipal(servicePrincipal);
        try {
            entry = (PrincipalStoreEntry)this.execute(config, (ContextOperation)getPrincipal);
        }
        catch (Exception e) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + config.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
        if (entry == null) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + config.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message);
        }
        EncryptionKey key = (EncryptionKey)entry.getKeyMap().get(EncryptionType.DES_CBC_MD5);
        byte[] keyBytes = key.getKeyValue();
        int type = key.getKeyType().getOrdinal();
        int kvno = key.getKeyVersion();
        KerberosKey serviceKey = new KerberosKey(servicePrincipal, keyBytes, type, kvno);
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(serviceKey);
        return subject;
    }

    private Object execute(LdapConfiguration config, ContextOperation operation) throws Exception {
        Hashtable<String, Object> env = this.getEnvironment(config);
        if (this.ctx == null) {
            try {
                this.ctx = new InitialLdapContext(env, null);
            }
            catch (NamingException ne) {
                String message = "Failed to get initial context " + (String)env.get("java.naming.provider.url");
                throw new ServiceConfigurationException(message, (Throwable)ne);
            }
        }
        return operation.execute(this.ctx, null);
    }

    private Hashtable<String, Object> getEnvironment(LdapConfiguration config) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", config.getInitialContextFactory());
        env.put("java.naming.provider.url", config.getSearchBaseDn());
        env.put("java.naming.security.authentication", config.getSecurityAuthentication());
        env.put("java.naming.security.credentials", config.getSecurityCredentials());
        env.put("java.naming.security.principal", config.getSecurityPrincipal());
        return env;
    }
}

