/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.AbstractLdapHandler;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDnHandler
extends AbstractLdapHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(ModifyDnHandler.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void messageReceived(IoSession session, Object request) throws Exception {
        ModifyDnRequest req = (ModifyDnRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        if (IS_DEBUG) {
            log.debug("req.getName() == [{}]", (Object)req.getName());
        }
        if (req.getName().isEmpty()) {
            String msg = "Modify DN is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.write((Object)req.getResultResponse());
        } else {
            try {
                LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
                if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                    ctx.addToEnvironment("java.naming.referral", "ignore");
                } else {
                    ctx.addToEnvironment("java.naming.referral", "throw");
                }
                this.setRequestControls(ctx, (Message)req);
                String deleteRDN = String.valueOf(req.getDeleteOldRdn());
                ctx.addToEnvironment("java.naming.ldap.deleteRDN", deleteRDN);
                LdapDN newSuperior = req.getNewSuperior();
                if (newSuperior != null && !newSuperior.isEmpty()) {
                    LdapDN oldDn = req.getName();
                    LdapDN newDn = null;
                    newDn = newSuperior;
                    if (req.getNewRdn() != null) {
                        newDn.add(req.getNewRdn());
                    } else {
                        newDn.add(oldDn.getRdn());
                    }
                    ctx.rename((Name)req.getName(), (Name)newDn);
                } else {
                    LdapDN newDn = (LdapDN)req.getName().clone();
                    newDn.remove(newDn.size() - 1);
                    newDn.add(req.getNewRdn());
                    ctx.rename((Name)req.getName(), (Name)newDn);
                }
                req.getResultResponse().addAll(ctx.getResponseControls());
                result.setResultCode(ResultCodeEnum.SUCCESS);
                session.write((Object)req.getResultResponse());
            }
            catch (ReferralException e) {
                ReferralImpl refs = new ReferralImpl();
                result.setReferral((Referral)refs);
                result.setResultCode(ResultCodeEnum.REFERRAL);
                result.setErrorMessage("Encountered referral attempting to handle modifyDn request.");
                result.setMatchedDn((LdapDN)e.getResolvedName());
                do {
                    refs.addLdapUrl((String)e.getReferralInfo());
                } while (e.skipReferral());
                session.write((Object)req.getResultResponse());
            }
            catch (NamingException e) {
                String msg = "failed to modify DN of entry " + req.getName() + ": " + e.getMessage();
                if (IS_DEBUG) {
                    msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                }
                ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
                result.setResultCode(code);
                result.setErrorMessage(msg);
                if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                    result.setMatchedDn((LdapDN)e.getResolvedName());
                }
                session.write((Object)req.getResultResponse());
            }
        }
    }
}

