/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.LdapConfiguration;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.AbstractLdapHandler;
import org.apache.directory.server.ldap.support.bind.BindHandlerChain;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindHandler
extends AbstractLdapHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(BindHandler.class);
    private IoHandlerCommand saslBindHandler = new BindHandlerChain();
    private static final String SIMPLE_AUTHENTICATION_LEVEL = "simple";
    private static final MutableControl[] EMPTY_CONTROL = new MutableControl[0];

    private Hashtable<String, Object> getEnvironment(IoSession session, BindRequest bindRequest, String authenticationLevel) {
        LdapDN principal = bindRequest.getName();
        byte[] credentials = bindRequest.getCredentials();
        if (log.isDebugEnabled()) {
            log.debug("{} {}", (Object)"java.naming.security.principal", (Object)principal);
            log.debug("{} {}", (Object)"java.naming.security.credentials", (Object)credentials);
            log.debug("{} {}", (Object)"java.naming.security.authentication", (Object)authenticationLevel);
        }
        Hashtable<String, Object> env = SessionRegistry.getSingleton().getEnvironmentByCopy();
        env.put("java.naming.security.principal", principal);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.security.authentication", authenticationLevel);
        if (bindRequest.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        return env;
    }

    private LdapContext getLdapContext(IoSession session, BindRequest bindRequest, Hashtable<String, Object> env) {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        LdapContext ctx = null;
        try {
            if (env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)env.get("server.use.factory.instance");
                if (factory == null) {
                    log.error("The property 'server.use.factory.instance'  was set in env but was null");
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(env);
            } else {
                MutableControl[] connCtls = bindRequest.getControls().values().toArray(EMPTY_CONTROL);
                ctx = new InitialLdapContext(env, (Control[])connCtls);
            }
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (log.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
                log.debug(msg);
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)bindRequest.getResultResponse());
            ctx = null;
        }
        return ctx;
    }

    private void handleSimpleAuth(IoSession session, BindRequest bindRequest) throws NamingException {
        LdapConfiguration config = (LdapConfiguration)((Object)session.getAttribute(LdapConfiguration.class.toString()));
        Set<String> supportedMechanisms = config.getSupportedMechanisms();
        LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
        if (!supportedMechanisms.contains("SIMPLE")) {
            log.error("Bind error : SIMPLE authentication not supported. Please check the server.xml configuration file (supportedMechanisms field)");
            bindResult.setResultCode(ResultCodeEnum.STRONG_AUTH_REQUIRED);
            bindResult.setErrorMessage("Simple binds are disabled.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        Hashtable<String, Object> env = this.getEnvironment(session, bindRequest, SIMPLE_AUTHENTICATION_LEVEL);
        LdapContext ctx = this.getLdapContext(session, bindRequest, env);
        if (ctx != null) {
            ServerLdapContext newCtx = (ServerLdapContext)ctx.lookup("");
            this.setRequestControls((LdapContext)newCtx, (Message)bindRequest);
            SessionRegistry.getSingleton().setLdapContext(session, (LdapContext)newCtx);
            bindResult.setResultCode(ResultCodeEnum.SUCCESS);
            BindResponse response = (BindResponse)bindRequest.getResultResponse();
            response.addAll(newCtx.getResponseControls());
            session.write((Object)response);
            log.debug("Returned SUCCESS message.");
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        BindRequest bindRequest = (BindRequest)message;
        if (log.isDebugEnabled()) {
            log.debug("User {} is binding", (Object)bindRequest.getName());
            if (bindRequest.isSimple()) {
                log.debug("Using simple authentication.");
            } else {
                log.debug("Using SASL authentication with mechanism:  {}", (Object)bindRequest.getSaslMechanism());
            }
        }
        if (!bindRequest.getVersion3()) {
            log.error("Bind error : Only LDAP v3 is supported.");
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setErrorMessage("Only LDAP v3 is supported.");
            session.write((Object)bindRequest.getResultResponse());
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(session, bindRequest);
        } else {
            this.saslBindHandler.execute(null, session, message);
        }
    }
}

