/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 3757127143811666817L;
    private static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    private static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private static final int IP_PORT_DEFAULT = 389;
    private boolean allowAnonymousAccess = true;
    private int maxSizeLimit = 100;
    private int maxTimeLimit = 10000;
    private boolean enableLdaps = false;
    private File ldapsCertificateFile = new File("server-work" + File.separator + "certificates" + File.separator + "server.cert");
    private String ldapsCertificatePassword = "changeit";
    private final Collection<ExtendedOperationHandler> extendedOperationHandlers = new ArrayList<ExtendedOperationHandler>();
    private Set<String> supportedMechanisms;
    private String saslHost = "ldap.example.com";
    private String saslPrincipal = "ldap/ldap.example.com@EXAMPLE.COM";
    private List<String> saslQop;
    private List<String> saslRealms;

    public LdapConfiguration() {
        super.setIpPort(389);
        super.setEnabled(true);
        this.supportedMechanisms = new HashSet<String>();
        this.supportedMechanisms.add("SIMPLE");
        this.supportedMechanisms.add("CRAM-MD5");
        this.supportedMechanisms.add("DIGEST-MD5");
        this.supportedMechanisms.add("GSSAPI");
        this.saslQop = new ArrayList<String>();
        this.saslQop.add("auth");
        this.saslQop.add("auth-int");
        this.saslQop.add("auth-conf");
        this.saslRealms = new ArrayList<String>();
        this.saslRealms.add("example.com");
    }

    public boolean isEnableLdaps() {
        return this.enableLdaps;
    }

    public void setEnableLdaps(boolean enableLdaps) {
        this.enableLdaps = enableLdaps;
    }

    public File getLdapsCertificateFile() {
        return this.ldapsCertificateFile;
    }

    public void setLdapsCertificateFile(File ldapsCertificateFile) {
        if (ldapsCertificateFile == null) {
            throw new ServiceConfigurationException("LdapsCertificateFile cannot be null.");
        }
        this.ldapsCertificateFile = ldapsCertificateFile;
    }

    public String getLdapsCertificatePassword() {
        return this.ldapsCertificatePassword;
    }

    public void setLdapsCertificatePassword(String ldapsCertificatePassword) {
        if (ldapsCertificatePassword == null) {
            throw new ServiceConfigurationException("LdapsCertificatePassword cannot be null.");
        }
        this.ldapsCertificatePassword = ldapsCertificatePassword;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    public void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public Collection getExtendedOperationHandlers() {
        return new ArrayList<ExtendedOperationHandler>(this.extendedOperationHandlers);
    }

    public void setExtendedOperationHandlers(Collection<ExtendedOperationHandler> handlers) {
        Iterator<ExtendedOperationHandler> i = handlers.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof ExtendedOperationHandler) continue;
            throw new IllegalArgumentException("The specified handler collection contains an element which is not an ExtendedOperationHandler.");
        }
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public List getSaslQop() {
        return this.saslQop;
    }

    public void setSaslQop(List<String> saslQop) {
        this.saslQop = saslQop;
    }

    public List getSaslRealms() {
        return this.saslRealms;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public Set<String> getSupportedMechanisms() {
        return this.supportedMechanisms;
    }

    public void setSupportedMechanisms(Set<String> supportedMechanisms) {
        this.supportedMechanisms = supportedMechanisms;
    }
}

