/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.extended;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolProvider;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.extended.JavaStoredProcedureExtendedOperationHandler;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.ldap.codec.extended.operations.StoredProcedure;
import org.apache.directory.shared.ldap.codec.extended.operations.StoredProcedureContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.StoredProcedureDecoder;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedResponse;
import org.apache.mina.common.IoSession;

public class StoredProcedureExtendedOperationHandler
implements ExtendedOperationHandler {
    private static final Set EXTENSION_OIDS;

    public void handleExtendedOperation(IoSession session, SessionRegistry registry, ExtendedRequest req) throws Exception {
        Control[] connCtls = req.getControls().values().toArray(new Control[req.getControls().size()]);
        LdapContext ldapContext = registry.getLdapContext(session, connCtls, false);
        ServerLdapContext serverLdapContext = ldapContext instanceof ServerLdapContext ? (ServerLdapContext)ldapContext : (ServerLdapContext)ldapContext.lookup("");
        StoredProcedure spBean = this.decodeBean(req.getPayload());
        JavaStoredProcedureExtendedOperationHandler handler = null;
        byte[] responseStream = null;
        if (spBean.getLanguage().equalsIgnoreCase("Java")) {
            handler = new JavaStoredProcedureExtendedOperationHandler();
            responseStream = handler.handleStoredProcedureExtendedOperation(serverLdapContext, spBean);
        }
        ((ExtendedResponse)req.getResultResponse()).setResponse(responseStream);
        session.write((Object)req.getResultResponse());
    }

    private StoredProcedure decodeBean(byte[] payload) {
        StoredProcedureDecoder storedProcedureDecoder = new StoredProcedureDecoder();
        ByteBuffer stream = ByteBuffer.wrap(payload);
        StoredProcedureContainer storedProcedureContainer = new StoredProcedureContainer();
        try {
            storedProcedureDecoder.decode(stream, (IAsn1Container)storedProcedureContainer);
        }
        catch (Exception de) {
            de.printStackTrace();
        }
        StoredProcedure spBean = storedProcedureContainer.getStoredProcedure();
        return spBean;
    }

    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.6";
    }

    public Set getExtensionOids() {
        return EXTENSION_OIDS;
    }

    public void setLdapProvider(LdapProtocolProvider provider) {
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("1.3.6.1.4.1.18060.0.1.6");
        s.add("1.3.6.1.4.1.18060.0.1.7");
        EXTENSION_OIDS = Collections.unmodifiableSet(s);
    }
}

