/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.extended;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.SerializationUtils;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.sp.LdapClassLoader;
import org.apache.directory.server.ldap.support.extended.LanguageSpecificStoredProceureExtendedOperationHandler;
import org.apache.directory.shared.ldap.codec.extended.operations.StoredProcedure;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.DirectoryClassUtils;
import org.apache.directory.shared.ldap.util.SpringClassUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class JavaStoredProcedureExtendedOperationHandler
implements LanguageSpecificStoredProceureExtendedOperationHandler {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public byte[] handleStoredProcedureExtendedOperation(ServerLdapContext ctx, StoredProcedure pojo) throws NamingException {
        ArrayList<Class> types = new ArrayList<Class>(pojo.getParameters().size());
        ArrayList<Object> values = new ArrayList<Object>(pojo.getParameters().size());
        for (StoredProcedure.StoredProcedureParameter pPojo : pojo.getParameters()) {
            Class type;
            String typeName;
            try {
                typeName = StringTools.utf8ToString((byte[])pPojo.getType());
                type = typeName.equals("$ldapContext") ? LdapContext.class : SpringClassUtils.forName((String)typeName);
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
            types.add(type);
            byte[] serializedValue = pPojo.getValue();
            try {
                if (typeName.equals("$ldapContext")) {
                    String newCtx = (String)SerializationUtils.deserialize((byte[])serializedValue);
                    values.add(ctx.lookup(newCtx));
                    continue;
                }
                values.add(SerializationUtils.deserialize((byte[])serializedValue));
            }
            catch (Exception e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
        }
        Object response = this.executeProcedure(ctx, StringTools.utf8ToString((byte[])pojo.getProcedure()), types.toArray(EMPTY_CLASS_ARRAY), values.toArray());
        byte[] serializedResponse = null;
        try {
            serializedResponse = SerializationUtils.serialize((Serializable)((Serializable)response));
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return serializedResponse;
    }

    public Object executeProcedure(ServerLdapContext ctx, String procedure, Class[] types, Object[] values) throws NamingException {
        int lastDot = procedure.lastIndexOf(46);
        String className = procedure.substring(0, lastDot);
        String methodName = procedure.substring(lastDot + 1);
        LdapClassLoader loader = new LdapClassLoader(ctx);
        try {
            Class clazz = loader.loadClass(className);
            Method proc = DirectoryClassUtils.getAssignmentCompatibleMethod((Class)clazz, (String)methodName, (Class[])types);
            return proc.invoke(null, values);
        }
        catch (Exception e) {
            LdapNamingException lne = new LdapNamingException(ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }
}

