/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.extended;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolProvider;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.extended.GracefulDisconnect;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownRequest;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownResponse;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownHandler
implements ExtendedOperationHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)GracefulShutdownHandler.class);
    public static final Set EXTENSION_OIDS;

    public String getOid() {
        return "1.2.6.1.4.1.18060.1.1.1.100.3";
    }

    public void handleExtendedOperation(IoSession requestor, SessionRegistry registry, ExtendedRequest req) throws NamingException {
        DirectoryService service = null;
        ServerLdapContext slc = null;
        LdapContext ctx = registry.getLdapContext(requestor, null, false);
        if (!((ctx = (LdapContext)ctx.lookup("")) instanceof ServerLdapContext)) {
            log.error("Encountered session context which was not a ServerLdapContext");
            GracefulShutdownResponse msg = new GracefulShutdownResponse(req.getMessageId(), ResultCodeEnum.OPERATIONSERROR);
            msg.getLdapResult().setErrorMessage("The session context was not a ServerLdapContext");
            requestor.write((Object)msg);
            return;
        }
        slc = (ServerLdapContext)ctx;
        service = slc.getService();
        if (!slc.getPrincipal().getName().equalsIgnoreCase("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
            if (log.isInfoEnabled()) {
                log.info("Rejected with insufficientAccessRights to attempt for server shutdown by " + slc.getPrincipal().getName());
            }
            requestor.write((Object)new GracefulShutdownResponse(req.getMessageId(), ResultCodeEnum.INSUFFICIENTACCESSRIGHTS));
            return;
        }
        IoAcceptor acceptor = (IoAcceptor)requestor.getService();
        ArrayList sessions = new ArrayList(acceptor.getManagedSessions(requestor.getServiceAddress()));
        StartupConfiguration cfg = service.getConfiguration().getStartupConfiguration();
        GracefulShutdownRequest gsreq = (GracefulShutdownRequest)req;
        PartitionNexus nexus = service.getConfiguration().getPartitionNexus();
        GracefulDisconnect notice = GracefulShutdownHandler.getGracefulDisconnect(gsreq.getTimeOffline(), gsreq.getDelay(), nexus);
        GracefulShutdownHandler.sendGracefulDisconnect(sessions, notice, requestor);
        GracefulShutdownHandler.waitForDelay(gsreq.getDelay());
        acceptor.unbind(requestor.getServiceAddress());
        GracefulShutdownHandler.sendNoticeOfDisconnect(sessions, requestor);
        GracefulShutdownHandler.sendShutdownResponse(requestor, req.getMessageId());
        if (cfg.isExitVmOnShutdown()) {
            System.exit(0);
        }
    }

    public static void sendShutdownResponse(IoSession requestor, int messageId) {
        GracefulShutdownResponse msg = new GracefulShutdownResponse(messageId, ResultCodeEnum.SUCCESS);
        WriteFuture future = requestor.write((Object)msg);
        future.join();
        if (future.isWritten()) {
            if (log.isInfoEnabled()) {
                log.info("Sent GracefulShutdownResponse to client: " + requestor.getRemoteAddress());
            }
        } else {
            log.error("Failed to write GracefulShutdownResponse to client: " + requestor.getRemoteAddress());
        }
        requestor.close();
    }

    public static void sendGracefulDisconnect(List sessions, GracefulDisconnect msg, IoSession requestor) {
        Iterator i;
        ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
        if (sessions != null) {
            i = sessions.iterator();
            while (i.hasNext()) {
                IoSession session = (IoSession)i.next();
                if (session.equals(requestor)) continue;
                try {
                    writeFutures.add(session.write((Object)msg));
                }
                catch (Exception e) {
                    log.warn("Failed to write GracefulDisconnect to client session: " + session, (Throwable)e);
                }
            }
        }
        i = writeFutures.iterator();
        while (i.hasNext()) {
            WriteFuture future = (WriteFuture)i.next();
            try {
                future.join(1000L);
            }
            catch (Exception e) {
                log.warn("Failed to sent GracefulDisconnect", (Throwable)e);
            }
        }
    }

    public static void sendNoticeOfDisconnect(List sessions, IoSession requestor) {
        ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
        if (sessions != null) {
            Iterator i = sessions.iterator();
            while (i.hasNext()) {
                IoSession session = (IoSession)i.next();
                if (session.equals(requestor)) continue;
                try {
                    writeFutures.add(session.write((Object)NoticeOfDisconnect.UNAVAILABLE));
                }
                catch (Exception e) {
                    log.warn("Failed to sent NoD for client: " + session, (Throwable)e);
                }
            }
        }
        Iterator sessionIt = sessions.iterator();
        Iterator i = writeFutures.iterator();
        while (i.hasNext()) {
            WriteFuture future = (WriteFuture)i.next();
            try {
                future.join(1000L);
                ((IoSession)sessionIt.next()).close();
            }
            catch (Exception e) {
                log.warn("Failed to sent NoD.", (Throwable)e);
            }
        }
    }

    public static GracefulDisconnect getGracefulDisconnect(int timeOffline, int delay, PartitionNexus nexus) {
        GracefulDisconnect notice = new GracefulDisconnect(timeOffline, delay);
        return notice;
    }

    public static void waitForDelay(int delay) {
        if (delay > 0) {
            long delayMillis = delay * 1000;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < delayMillis) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    log.warn("Got interrupted while waiting for delay before shutdown", (Throwable)e);
                }
            }
        }
    }

    public Set getExtensionOids() {
        return EXTENSION_OIDS;
    }

    public void setLdapProvider(LdapProtocolProvider provider) {
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("1.2.6.1.4.1.18060.1.1.1.100.3");
        set.add("1.2.6.1.4.1.18060.1.1.1.100.4");
        set.add("1.2.6.1.4.1.18060.1.1.1.100.5");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

