/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamingListener;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.PersistentSearchListener;
import org.apache.directory.server.ldap.support.SearchResponseIterator;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.PersistentSearchControl;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.directory.shared.ldap.message.Response;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ScopeEnum;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.SearchResponseDone;
import org.apache.directory.shared.ldap.name.LdapName;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchHandler.class);
    private static final String DEREFALIASES_KEY = "java.naming.ldap.derefAliases";

    private static SearchControls getSearchControls(SearchRequest req, String[] ids) {
        SearchControls controls = new SearchControls();
        controls.setCountLimit(req.getSizeLimit());
        controls.setTimeLimit(req.getTimeLimit());
        controls.setSearchScope(req.getScope().getValue());
        controls.setReturningObjFlag(req.getTypesOnly());
        controls.setReturningAttributes(ids);
        controls.setDerefLinkFlag(true);
        return controls;
    }

    private static boolean isRootDSESearch(SearchRequest req) {
        boolean isBaseIsRoot = req.getBase().trim().equals("");
        boolean isBaseScope = req.getScope() == ScopeEnum.BASEOBJECT;
        boolean isRootDSEFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            isRootDSEFilter = ((PresenceNode)req.getFilter()).getAttribute().equalsIgnoreCase("objectClass");
        }
        return isBaseIsRoot && isBaseScope && isRootDSEFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object request) {
        if (log.isDebugEnabled()) {
            log.debug("Message received : " + request.toString());
        }
        SearchRequest req = (SearchRequest)request;
        NamingEnumeration list = null;
        String[] ids = null;
        HashSet<String> retAttrs = new HashSet<String>();
        retAttrs.addAll(req.getAttributes());
        SessionRegistry.getSingleton().addOutstandingRequest(session, (Request)req);
        if (retAttrs.size() > 0 && !retAttrs.contains("ref")) {
            retAttrs.add("ref");
            ids = retAttrs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        } else if (retAttrs.size() > 0) {
            ids = retAttrs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
        SearchControls controls = SearchHandler.getSearchControls(req, ids);
        try {
            LdapContext unknown;
            boolean isRootDSESearch = SearchHandler.isRootDSESearch(req);
            ServerLdapContext ctx = isRootDSESearch ? (!((unknown = SessionRegistry.getSingleton().getLdapContextOnRootDSEAccess(session, null)) instanceof ServerLdapContext) ? (ServerLdapContext)unknown.lookup("") : (ServerLdapContext)unknown) : (!((unknown = SessionRegistry.getSingleton().getLdapContext(session, null, true)) instanceof ServerLdapContext) ? (ServerLdapContext)unknown.lookup("") : (ServerLdapContext)unknown);
            ctx.addToEnvironment(DEREFALIASES_KEY, (Object)req.getDerefAliases().getName());
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                ctx.addToEnvironment("java.naming.referral", (Object)"ignore");
            } else {
                ctx.addToEnvironment("java.naming.referral", (Object)"throw-finding-base");
            }
            StartupConfiguration cfg = (StartupConfiguration)Configuration.toConfiguration((Hashtable)ctx.getEnvironment());
            boolean allowAnonymousBinds = cfg.isAllowAnonymousAccess();
            boolean isAnonymousUser = ctx.getPrincipal().getName().trim().equals("");
            if (isAnonymousUser && !allowAnonymousBinds && !isRootDSESearch) {
                LdapResult result = req.getResultResponse().getLdapResult();
                result.setResultCode(ResultCodeEnum.INSUFFICIENTACCESSRIGHTS);
                String msg = "Bind failure: Anonymous binds have been disabled!";
                result.setErrorMessage(msg);
                session.write((Object)req.getResultResponse());
                return;
            }
            PersistentSearchControl psearchControl = (PersistentSearchControl)req.getControls().get("2.16.840.1.113730.3.4.3");
            if (psearchControl != null) {
                controls.setCountLimit(0L);
                controls.setTimeLimit(0);
                if (!psearchControl.isChangesOnly()) {
                    list = ctx.search((Name)new LdapName(req.getBase()), req.getFilter(), controls);
                    if (list instanceof AbandonListener) {
                        req.addAbandonListener((AbandonListener)list);
                    }
                    if (list.hasMore()) {
                        SearchResponseIterator it = new SearchResponseIterator(req, ctx, list, controls.getSearchScope());
                        while (it.hasNext()) {
                            Response resp = (Response)it.next();
                            if (resp instanceof SearchResponseDone) {
                                ResultCodeEnum rcode = ((SearchResponseDone)resp).getLdapResult().getResultCode();
                                if (rcode.getValue() == 0) break;
                                session.write((Object)resp);
                                return;
                            }
                            session.write((Object)resp);
                        }
                    }
                }
                PersistentSearchListener handler = new PersistentSearchListener(ctx, session, req);
                StringBuffer buf = new StringBuffer();
                req.getFilter().printToBuffer(buf);
                ctx.addNamingListener(req.getBase(), buf.toString(), controls, (NamingListener)handler);
                SessionRegistry.getSingleton().addOutstandingRequest(session, (Request)req);
                return;
            }
            list = ctx.search((Name)new LdapName(req.getBase()), req.getFilter(), controls);
            if (list instanceof AbandonListener) {
                req.addAbandonListener((AbandonListener)list);
            }
            if (list.hasMore()) {
                SearchResponseIterator it = new SearchResponseIterator(req, ctx, list, controls.getSearchScope());
                while (it.hasNext()) {
                    session.write(it.next());
                }
                return;
            }
            list.close();
            req.getResultResponse().getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            Iterator<ResultResponse> it = Collections.singleton(req.getResultResponse()).iterator();
            while (it.hasNext()) {
                session.write((Object)it.next());
            }
            return;
        }
        catch (ReferralException e) {
            LdapResult result = req.getResultResponse().getLdapResult();
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle add request.");
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
            SessionRegistry.getSingleton().removeOutstandingRequest(session, req.getMessageId());
            return;
        }
        catch (NamingException e) {
            if (e instanceof OperationAbandonedException) {
                return;
            }
            String msg = "failed on search operation";
            if (log.isDebugEnabled()) {
                msg = msg + ":\n" + req + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = null;
            code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                result.setMatchedDn(e.getResolvedName().toString());
            }
            Iterator<ResultResponse> it = Collections.singleton(req.getResultResponse()).iterator();
            while (it.hasNext()) {
                session.write((Object)it.next());
            }
            SessionRegistry.getSingleton().removeOutstandingRequest(session, req.getMessageId());
        }
        finally {
            if (list != null) {
                try {
                    list.close();
                }
                catch (NamingException e) {
                    log.error("failed on list.close()", (Throwable)e);
                }
            }
        }
    }
}

