/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapName;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDnHandler
implements MessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger((Class)ModifyDnHandler.class);
    private static Control[] EMPTY_CONTROLS = new Control[0];

    public void messageReceived(IoSession session, Object request) {
        ModifyDnRequest req = (ModifyDnRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        if (LOG.isDebugEnabled()) {
            LOG.debug("req.getName() == [" + req.getName() + "]");
        }
        if (req.getName() == null || req.getName().length() == 0) {
            String msg = "Modify DN is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOLERROR);
            result.setErrorMessage(msg);
            session.write((Object)req.getResultResponse());
        } else {
            try {
                LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
                if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                    ctx.addToEnvironment("java.naming.referral", "ignore");
                } else {
                    ctx.addToEnvironment("java.naming.referral", "throw");
                }
                ctx.setRequestControls((javax.naming.ldap.Control[])req.getControls().values().toArray(EMPTY_CONTROLS));
                String deleteRDN = String.valueOf(req.getDeleteOldRdn());
                ctx.addToEnvironment("java.naming.ldap.deleteRDN", deleteRDN);
                if (req.isMove()) {
                    LdapName oldDn = new LdapName(req.getName());
                    LdapName newDn = null;
                    String newSuperior = req.getNewSuperior();
                    newDn = StringTools.isEmpty((String)newSuperior) ? (LdapName)oldDn.getPrefix(1) : new LdapName(req.getNewSuperior());
                    if (req.getNewRdn() != null) {
                        newDn.add(req.getNewRdn());
                    } else {
                        newDn.add(oldDn.getRdn());
                    }
                    ctx.rename((Name)new LdapName(req.getName()), (Name)newDn);
                } else {
                    LdapName newDn = new LdapName(req.getName());
                    newDn.remove(newDn.size() - 1);
                    newDn.add(req.getNewRdn());
                    ctx.rename((Name)new LdapName(req.getName()), (Name)newDn);
                }
            }
            catch (ReferralException e) {
                ReferralImpl refs = new ReferralImpl();
                result.setReferral((Referral)refs);
                result.setResultCode(ResultCodeEnum.REFERRAL);
                result.setErrorMessage("Encountered referral attempting to handle modifyDn request.");
                do {
                    refs.addLdapUrl((String)e.getReferralInfo());
                } while (e.skipReferral());
                session.write((Object)req.getResultResponse());
                return;
            }
            catch (NamingException e) {
                String msg = "failed to modify DN of entry " + req.getName();
                if (LOG.isDebugEnabled()) {
                    msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                }
                ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
                result.setResultCode(code);
                result.setErrorMessage(msg);
                if (e.getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                    result.setMatchedDn(e.getResolvedName().toString());
                }
                session.write((Object)req.getResultResponse());
                return;
            }
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.write((Object)req.getResultResponse());
        }
    }
}

