/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.store.jndi.DnsOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRecords
implements DnsOperation {
    private static final long serialVersionUID = 1077580995617778894L;
    private final QuestionRecord question;
    private static final Map<RecordType, String> TYPE_TO_OBJECTCLASS;
    private static final Map<String, RecordType> OBJECTCLASS_TO_TYPE;

    public GetRecords(QuestionRecord question) {
        this.question = question;
    }

    @Override
    public Set<ResourceRecord> execute(DirContext ctx, Name base) throws Exception {
        if (this.question == null) {
            return null;
        }
        String name = this.question.getDomainName();
        RecordType type = this.question.getRecordType();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        String filter = "(objectClass=" + TYPE_TO_OBJECTCLASS.get(type) + ")";
        NamingEnumeration<SearchResult> list = ctx.search(this.transformDomainName(name), filter, controls);
        HashSet<ResourceRecord> set = new HashSet<ResourceRecord>();
        while (list.hasMore()) {
            SearchResult result = list.next();
            Name relative = this.getRelativeName(ctx.getNameInNamespace(), result.getName());
            set.add(this.getRecord(result.getAttributes(), relative));
        }
        return set;
    }

    private ResourceRecord getRecord(Attributes attrs, Name relative) throws NamingException {
        String SOA_MINIMUM = "86400";
        String SOA_CLASS = "IN";
        ResourceRecordModifier modifier = new ResourceRecordModifier();
        Attribute attr = attrs.get("apacheDnsName");
        if (attr != null) {
            modifier.setDnsName((String)attr.get());
        } else {
            relative = this.getDomainComponents(relative);
            String dnsName = this.transformDistinguishedName(relative.toString());
            modifier.setDnsName(dnsName);
        }
        attr = attrs.get("apacheDnsType");
        if (attr != null) {
            modifier.setDnsType(RecordType.valueOf((String)attr.get()));
        } else {
            modifier.setDnsType(this.getType(attrs.get("objectClass")));
        }
        attr = attrs.get("apacheDnsClass");
        String dnsClass = attr != null ? (String)attr.get() : SOA_CLASS;
        modifier.setDnsClass(RecordClass.valueOf(dnsClass));
        attr = attrs.get("apacheDnsTtl");
        String dnsTtl = attr != null ? (String)attr.get() : SOA_MINIMUM;
        modifier.setDnsTtl(Integer.parseInt(dnsTtl));
        NamingEnumeration<String> ids = attrs.getIDs();
        while (ids.hasMore()) {
            String id = ids.next();
            modifier.put(id, (String)attrs.get(id).get());
        }
        return modifier.getEntry();
    }

    String transformDomainName(String domainName) {
        if (domainName == null || domainName.length() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(domainName.length() + 16);
        buf.append("dc=");
        buf.append(domainName.replaceAll("\\.", ",dc="));
        return buf.toString();
    }

    String transformDistinguishedName(String distinguishedName) {
        if (distinguishedName == null || distinguishedName.length() == 0) {
            return "";
        }
        String domainName = distinguishedName.replaceFirst("dc=", "");
        domainName = domainName.replaceAll(",dc=", ".");
        return domainName;
    }

    private RecordType getType(Attribute objectClass) throws NamingException {
        NamingEnumeration<?> list = objectClass.getAll();
        while (list.hasMore()) {
            String value = (String)list.next();
            if (value.equals("apacheDnsAbstractRecord")) continue;
            RecordType type = OBJECTCLASS_TO_TYPE.get(value);
            if (type == null) {
                throw new RuntimeException("Record type to objectClass mapping has not been set.");
            }
            return type;
        }
        throw new NamingException("ResourceRecord requires STRUCTURAL objectClass");
    }

    private Name getRelativeName(String nameInNamespace, String baseDn) throws NamingException {
        Properties props = new Properties();
        props.setProperty("jndi.syntax.direction", "right_to_left");
        props.setProperty("jndi.syntax.separator", ",");
        props.setProperty("jndi.syntax.ignorecase", "true");
        props.setProperty("jndi.syntax.trimblanks", "true");
        CompoundName searchBaseDn = null;
        CompoundName ctxRoot = new CompoundName(nameInNamespace, props);
        searchBaseDn = new CompoundName(baseDn, props);
        if (!searchBaseDn.startsWith(ctxRoot)) {
            throw new NamingException("Invalid search base " + baseDn);
        }
        for (int ii = 0; ii < ctxRoot.size(); ++ii) {
            searchBaseDn.remove(0);
        }
        return searchBaseDn;
    }

    private Name getDomainComponents(Name name) throws NamingException {
        for (int ii = 0; ii < name.size(); ++ii) {
            if (name.get(ii).startsWith("dc=")) continue;
            name.remove(ii);
        }
        return name;
    }

    static {
        HashMap<RecordType, String> typeToObjectClass = new HashMap<RecordType, String>();
        typeToObjectClass.put(RecordType.SOA, "apacheDnsStartOfAuthorityRecord");
        typeToObjectClass.put(RecordType.A, "apacheDnsAddressRecord");
        typeToObjectClass.put(RecordType.NS, "apacheDnsNameServerRecord");
        typeToObjectClass.put(RecordType.CNAME, "apacheDnsCanonicalNameRecord");
        typeToObjectClass.put(RecordType.PTR, "apacheDnsPointerRecord");
        typeToObjectClass.put(RecordType.MX, "apacheDnsMailExchangeRecord");
        typeToObjectClass.put(RecordType.SRV, "apacheDnsServiceRecord");
        typeToObjectClass.put(RecordType.TXT, "apacheDnsTextRecord");
        TYPE_TO_OBJECTCLASS = Collections.unmodifiableMap(typeToObjectClass);
        HashMap<String, RecordType> objectClassToType = new HashMap<String, RecordType>();
        objectClassToType.put("apacheDnsStartOfAuthorityRecord", RecordType.SOA);
        objectClassToType.put("apacheDnsAddressRecord", RecordType.A);
        objectClassToType.put("apacheDnsNameServerRecord", RecordType.NS);
        objectClassToType.put("apacheDnsCanonicalNameRecord", RecordType.CNAME);
        objectClassToType.put("apacheDnsPointerRecord", RecordType.PTR);
        objectClassToType.put("apacheDnsMailExchangeRecord", RecordType.MX);
        objectClassToType.put("apacheDnsServiceRecord", RecordType.SRV);
        objectClassToType.put("apacheDnsTextRecord", RecordType.TXT);
        objectClassToType.put("apacheDnsReferralNameServer", RecordType.NS);
        objectClassToType.put("apacheDnsReferralAddress", RecordType.A);
        OBJECTCLASS_TO_TYPE = Collections.unmodifiableMap(objectClassToType);
    }
}

