/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.encoder;

import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.mina.common.ByteBuffer;

public class QuestionRecordEncoder {
    public void put(ByteBuffer out, QuestionRecord question) {
        this.encodeDomainName(out, question.getDomainName());
        this.encodeRecordType(out, question.getRecordType());
        this.encodeRecordClass(out, question.getRecordClass());
    }

    private void encodeDomainName(ByteBuffer byteBuffer, String domainName) {
        String[] labels = domainName.split("\\.");
        for (int ii = 0; ii < labels.length; ++ii) {
            byteBuffer.put((byte)labels[ii].length());
            char[] characters = labels[ii].toCharArray();
            for (int jj = 0; jj < characters.length; ++jj) {
                byteBuffer.put((byte)characters[jj]);
            }
        }
        byteBuffer.put((byte)0);
    }

    private void encodeRecordType(ByteBuffer byteBuffer, RecordType recordType) {
        byteBuffer.putShort(recordType.convert().shortValue());
    }

    private void encodeRecordClass(ByteBuffer byteBuffer, RecordClass recordClass) {
        byteBuffer.putShort(recordClass.convert().shortValue());
    }
}

