/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.jndi.DnsCatalog;
import org.apache.directory.server.dns.store.jndi.DnsOperation;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.operations.GetRecords;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBaseSearch
implements SearchStrategy {
    private static final Logger log = LoggerFactory.getLogger(MultiBaseSearch.class);
    private InitialContextFactory factory;
    private Hashtable<String, Object> env = new Hashtable();
    private Catalog catalog;

    MultiBaseSearch(DnsConfiguration config, InitialContextFactory factory) {
        this.factory = factory;
        this.env.put("java.naming.factory.initial", config.getInitialContextFactory());
        this.env.put("java.naming.provider.url", config.getCatalogBaseDn());
        try {
            DirContext ctx = (DirContext)factory.getInitialContext(this.env);
            this.catalog = new DnsCatalog((Map)this.execute(ctx, (ContextOperation)new GetCatalog()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String message = "Failed to get catalog context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        this.env.put("java.naming.provider.url", this.catalog.getBaseDn(question.getDomainName()));
        try {
            DirContext ctx = (DirContext)this.factory.getInitialContext(this.env);
            return this.execute(ctx, new GetRecords(question));
        }
        catch (LdapNameNotFoundException lnnfe) {
            log.debug("Name for DNS record search does not exist.", (Throwable)lnnfe);
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        catch (NamingException ne) {
            log.error(ne.getMessage(), (Throwable)ne);
            String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
        catch (Exception e) {
            log.debug("Unexpected error retrieving DNS records.", (Throwable)e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
    }

    private Object execute(DirContext ctx, ContextOperation operation) throws Exception {
        return operation.execute(ctx, null);
    }

    private Set<ResourceRecord> execute(DirContext ctx, DnsOperation operation) throws Exception {
        return operation.execute(ctx, null);
    }
}

