/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class BuildReply
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        DnsContext dnsContext = (DnsContext)session.getAttribute(this.getContextKey());
        List<ResourceRecord> records = dnsContext.getResourceRecords();
        DnsMessage request = (DnsMessage)message;
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setTransactionId(request.getTransactionId());
        modifier.setMessageType(MessageType.RESPONSE);
        modifier.setOpCode(OpCode.QUERY);
        modifier.setAuthoritativeAnswer(false);
        modifier.setTruncated(false);
        modifier.setRecursionDesired(request.isRecursionDesired());
        modifier.setRecursionAvailable(false);
        modifier.setReserved(false);
        modifier.setAcceptNonAuthenticatedData(false);
        modifier.setResponseCode(ResponseCode.NO_ERROR);
        modifier.setQuestionRecords(request.getQuestionRecords());
        modifier.setAnswerRecords(records);
        modifier.setAuthorityRecords(new ArrayList<ResourceRecord>());
        modifier.setAdditionalRecords(new ArrayList<ResourceRecord>());
        dnsContext.setReply(modifier.getDnsMessage());
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

