/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.operations;

import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;

public class GetFlatRecord
implements ContextOperation {
    private static final long serialVersionUID = 4931303293468915435L;
    private final QuestionRecord question;

    public GetFlatRecord(QuestionRecord question) {
        this.question = question;
    }

    public Object execute(DirContext ctx, Name base) throws Exception {
        if (this.question == null) {
            return null;
        }
        AttributesImpl matchAttrs = new AttributesImpl(true);
        matchAttrs.put((Attribute)new AttributeImpl("apacheDnsName", (Object)this.question.getDomainName()));
        matchAttrs.put((Attribute)new AttributeImpl("apacheDnsType", (Object)this.question.getRecordType().name()));
        matchAttrs.put((Attribute)new AttributeImpl("apacheDnsClass", (Object)this.question.getRecordClass().name()));
        ResourceRecord record = null;
        NamingEnumeration<SearchResult> answer = ctx.search(base, (Attributes)matchAttrs);
        if (answer.hasMore()) {
            SearchResult result = answer.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) {
                return null;
            }
            record = this.getRecord(attrs);
        }
        return record;
    }

    private ResourceRecord getRecord(Attributes attrs) throws NamingException {
        ResourceRecordModifier modifier = new ResourceRecordModifier();
        Attribute attr = attrs.get("apacheDnsName");
        String dnsName = attr != null ? (String)attr.get() : null;
        attr = attrs.get("apacheDnsType");
        String dnsType = attr != null ? (String)attr.get() : null;
        attr = attrs.get("apacheDnsClass");
        String dnsClass = attr != null ? (String)attr.get() : null;
        attr = attrs.get("apacheDnsTtl");
        String dnsTtl = attr != null ? (String)attr.get() : null;
        modifier.setDnsName(dnsName);
        modifier.setDnsType(RecordType.valueOf(dnsType));
        modifier.setDnsClass(RecordClass.valueOf(dnsClass));
        modifier.setDnsTtl(Integer.parseInt(dnsTtl));
        NamingEnumeration<String> ids = attrs.getIDs();
        while (ids.hasMore()) {
            String id = ids.next();
            modifier.put(id, (String)attrs.get(id).get());
        }
        return modifier.getEntry();
    }
}

