/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store;

import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.store.SearchStrategy;
import org.apache.directory.server.dns.store.operations.GetRecords;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBaseSearch
implements SearchStrategy {
    private static final Logger log = LoggerFactory.getLogger(SingleBaseSearch.class);
    private DirContext ctx;

    SingleBaseSearch(DnsConfiguration config, InitialContextFactory factory) {
        Hashtable<String, String> env = new Hashtable<String, String>(config.toJndiEnvironment());
        env.put("java.naming.factory.initial", config.getInitialContextFactory());
        env.put("java.naming.provider.url", config.getEntryBaseDn());
        try {
            this.ctx = (DirContext)factory.getInitialContext(env);
        }
        catch (NamingException ne) {
            log.error(ne.getMessage(), (Throwable)ne);
            String message = "Failed to get initial context " + (String)env.get("java.naming.provider.url");
            throw new ConfigurationException(message, (Throwable)ne);
        }
    }

    public Set getRecords(QuestionRecord question) throws Exception {
        return (Set)this.execute(new GetRecords(question));
    }

    private Object execute(ContextOperation operation) throws Exception {
        return operation.execute(this.ctx, null);
    }
}

