/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.List;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.mina.handler.chain.IoHandlerCommand;

public abstract class MonitorMessage
implements IoHandlerCommand {
    protected String monitorMessage(DnsMessage message, String direction) {
        MessageType messageType = message.getMessageType();
        OpCode opCode = message.getOpCode();
        ResponseCode responseCode = message.getResponseCode();
        int transactionId = message.getTransactionId();
        StringBuffer sb = new StringBuffer();
        sb.append("Monitoring " + direction + ":");
        sb.append("\n\tmessageType                " + messageType);
        sb.append("\n\topCode                     " + opCode);
        sb.append("\n\tresponseCode               " + responseCode);
        sb.append("\n\ttransactionId              " + transactionId);
        sb.append("\n\tauthoritativeAnswer        " + message.isAuthoritativeAnswer());
        sb.append("\n\ttruncated                  " + message.isTruncated());
        sb.append("\n\trecursionDesired           " + message.isRecursionDesired());
        sb.append("\n\trecursionAvailable         " + message.isRecursionAvailable());
        sb.append("\n\treserved                   " + message.isReserved());
        sb.append("\n\tacceptNonAuthenticatedData " + message.isAcceptNonAuthenticatedData());
        List<QuestionRecord> questions = message.getQuestionRecords();
        sb.append("\n\tquestions:                 " + questions);
        return sb.toString();
    }
}

