/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetResourceRecords
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(GetResourceRecords.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        DnsContext dnsContext = (DnsContext)session.getAttribute(this.getContextKey());
        RecordStore store = dnsContext.getStore();
        DnsMessage request = (DnsMessage)message;
        List<QuestionRecord> questions = request.getQuestionRecords();
        Iterator<QuestionRecord> it = questions.iterator();
        while (it.hasNext()) {
            dnsContext.addResourceRecords(this.getEntry(store, it.next()));
        }
        next.execute(session, message);
    }

    public Set getEntry(RecordStore store, QuestionRecord question) throws Exception {
        Set records = null;
        try {
            records = store.getRecords(question);
        }
        catch (LdapNameNotFoundException lnnfe) {
            log.debug("Name for DNS record search does not exist.", (Throwable)lnnfe);
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        catch (Exception e) {
            log.debug("Unexpected error retrieving DNS records.", (Throwable)e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
        if (records == null || records.isEmpty()) {
            log.debug("The domain name referenced in the query does not exist.");
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        return records;
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

